/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import com.google.common.base.Function;
import io.appium.java_client.pagefactory.ThrowableUtil;
import io.appium.java_client.pagefactory.TimeOutDuration;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

class AppiumElementLocator
implements CacheableLocator {
    private final boolean shouldCache;
    private final By by;
    private final TimeOutDuration timeOutDuration;
    private final TimeOutDuration originalTimeOutDuration;
    private final WebDriver originalWebDriver;
    private final SearchContext searchContext;
    private final WaitingFunction waitingFunction;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;

    public AppiumElementLocator(SearchContext searchContext, By by, boolean shouldCache, TimeOutDuration duration, TimeOutDuration originalDuration, WebDriver originalWebDriver) {
        this.searchContext = searchContext;
        this.shouldCache = shouldCache;
        this.timeOutDuration = duration;
        this.originalTimeOutDuration = originalDuration;
        this.by = by;
        this.originalWebDriver = originalWebDriver;
        this.waitingFunction = new WaitingFunction(this.searchContext);
    }

    private void changeImplicitlyWaitTimeOut(long newTimeOut, TimeUnit newTimeUnit) {
        this.originalWebDriver.manage().timeouts().implicitlyWait(newTimeOut, newTimeUnit);
    }

    private List<WebElement> waitFor() {
        try {
            this.changeImplicitlyWaitTimeOut(0L, TimeUnit.SECONDS);
            FluentWait wait = new FluentWait((Object)this.by);
            wait.withTimeout(this.timeOutDuration.getTime(), this.timeOutDuration.getTimeUnit());
            List list = (List)wait.until((Function)this.waitingFunction);
            return list;
        }
        catch (TimeoutException timeoutException) {
            ArrayList<WebElement> arrayList = new ArrayList<WebElement>();
            return arrayList;
        }
        finally {
            this.changeImplicitlyWaitTimeOut(this.originalTimeOutDuration.getTime(), this.originalTimeOutDuration.getTimeUnit());
        }
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        List<WebElement> result = this.waitFor();
        if (result.size() == 0) {
            String message = "Can't locate an element by this strategy: " + this.by.toString();
            if (this.waitingFunction.foundStaleElementReferenceException != null) {
                throw new NoSuchElementException(message, this.waitingFunction.foundStaleElementReferenceException);
            }
            throw new NoSuchElementException(message);
        }
        if (this.shouldCache) {
            this.cachedElement = result.get(0);
        }
        return result.get(0);
    }

    public List<WebElement> findElements() {
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        List<WebElement> result = this.waitFor();
        if (this.shouldCache) {
            this.cachedElementList = result;
        }
        return result;
    }

    @Override
    public boolean isLookUpCached() {
        return this.shouldCache;
    }

    private static class WaitingFunction
    implements Function<By, List<WebElement>> {
        private final SearchContext searchContext;
        Throwable foundStaleElementReferenceException;

        private WaitingFunction(SearchContext searchContext) {
            this.searchContext = searchContext;
        }

        public List<WebElement> apply(By by) {
            Object shouldBeThrown;
            ArrayList<WebElement> result;
            block7: {
                result = new ArrayList<WebElement>();
                shouldBeThrown = null;
                boolean isRootCauseStaleElementReferenceException = false;
                this.foundStaleElementReferenceException = null;
                try {
                    result.addAll(this.searchContext.findElements(by));
                }
                catch (Throwable e) {
                    boolean isRootCauseInvalidSelector = ThrowableUtil.isInvalidSelectorRootCause(e);
                    if (!isRootCauseInvalidSelector) {
                        isRootCauseStaleElementReferenceException = ThrowableUtil.isStaleElementReferenceException(e);
                    }
                    if (isRootCauseStaleElementReferenceException) {
                        this.foundStaleElementReferenceException = ThrowableUtil.extractReadableException(e);
                    }
                    if (!(!isRootCauseInvalidSelector & !isRootCauseStaleElementReferenceException)) break block7;
                    shouldBeThrown = ThrowableUtil.extractReadableException(e);
                }
            }
            if (shouldBeThrown != null) {
                if (RuntimeException.class.isAssignableFrom(shouldBeThrown.getClass())) {
                    throw (RuntimeException)shouldBeThrown;
                }
                throw new RuntimeException((Throwable)shouldBeThrown);
            }
            if (result.size() > 0) {
                return result;
            }
            return null;
        }
    }
}

