/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumExecutionMethod;
import io.appium.java_client.DefaultGenericMobileDriver;
import io.appium.java_client.ErrorCodesMobile;
import io.appium.java_client.HasSessionDetails;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.TouchAction;
import io.appium.java_client.internal.JsonToMobileElementConverter;
import io.appium.java_client.remote.AppiumCommandExecutor;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.DeviceRotation;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.http.HttpClient;

public class AppiumDriver<T extends WebElement>
extends DefaultGenericMobileDriver<T> {
    private static final ErrorHandler errorHandler = new ErrorHandler((ErrorCodes)new ErrorCodesMobile(), true);
    private URL remoteAddress;
    private RemoteLocationContext locationContext;
    private ExecuteMethod executeMethod = new AppiumExecutionMethod(this);
    private final String platformName;
    private final String automationName;
    private String currentContext;

    public AppiumDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super((CommandExecutor)executor, capabilities);
        this.locationContext = new RemoteLocationContext(this.executeMethod);
        super.setErrorHandler(errorHandler);
        this.remoteAddress = executor.getAddressOfRemoteServer();
        final AppiumDriver driver = this;
        HasSessionDetails hasSessionDetails = new HasSessionDetails(){

            @Override
            public Response execute(String driverCommand, Map<String, ?> parameters) {
                return driver.execute(driverCommand, (Map)parameters);
            }

            @Override
            public Response execute(String driverCommand) {
                return driver.execute(driverCommand);
            }
        };
        Object capabilityPlatform1 = this.getCapabilities().getCapability("platformName");
        Object capabilityAutomation1 = this.getCapabilities().getCapability("automationName");
        Object capabilityPlatform2 = capabilities.getCapability("platformName");
        Object capabilityAutomation2 = capabilities.getCapability("automationName");
        this.platformName = Optional.ofNullable(Optional.ofNullable(hasSessionDetails.getPlatformName()).orElse(capabilityPlatform1 != null ? String.valueOf(capabilityPlatform1) : null)).orElse(capabilityPlatform2 != null ? String.valueOf(capabilityPlatform2) : null);
        this.automationName = Optional.ofNullable(Optional.ofNullable(hasSessionDetails.getAutomationName()).orElse(capabilityAutomation1 != null ? String.valueOf(capabilityAutomation1) : null)).orElse(capabilityAutomation2 != null ? String.valueOf(capabilityAutomation2) : null);
        this.setElementConverter(new JsonToMobileElementConverter(this, this));
        this.currentContext = this.getContext();
    }

    public AppiumDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress), desiredCapabilities);
    }

    public AppiumDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress, httpClientFactory), desiredCapabilities);
    }

    public AppiumDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, service), desiredCapabilities);
    }

    public AppiumDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, service, httpClientFactory), desiredCapabilities);
    }

    public AppiumDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        this((AppiumDriverLocalService)builder.build(), desiredCapabilities);
    }

    public AppiumDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        this((AppiumDriverLocalService)builder.build(), httpClientFactory, desiredCapabilities);
    }

    public AppiumDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        this(AppiumDriverLocalService.buildDefaultService(), httpClientFactory, desiredCapabilities);
    }

    public AppiumDriver(Capabilities desiredCapabilities) {
        this(AppiumDriverLocalService.buildDefaultService(), desiredCapabilities);
    }

    protected static Capabilities substituteMobilePlatform(Capabilities originalCapabilities, String newPlatform) {
        DesiredCapabilities dc = new DesiredCapabilities(originalCapabilities);
        dc.setCapability("platformName", newPlatform);
        return dc;
    }

    @Override
    public List<T> findElements(By by) {
        return super.findElements(by);
    }

    @Override
    public List<T> findElements(String by, String using) {
        return super.findElements(by, using);
    }

    @Override
    public List<T> findElementsById(String id) {
        return super.findElementsById(id);
    }

    @Override
    public List<T> findElementsByLinkText(String using) {
        return super.findElementsByLinkText(using);
    }

    @Override
    public List<T> findElementsByPartialLinkText(String using) {
        return super.findElementsByPartialLinkText(using);
    }

    @Override
    public List<T> findElementsByTagName(String using) {
        return super.findElementsByTagName(using);
    }

    @Override
    public List<T> findElementsByName(String using) {
        return super.findElementsByName(using);
    }

    @Override
    public List<T> findElementsByClassName(String using) {
        return super.findElementsByClassName(using);
    }

    @Override
    public List<T> findElementsByCssSelector(String using) {
        return super.findElementsByCssSelector(using);
    }

    @Override
    public List<T> findElementsByXPath(String using) {
        return super.findElementsByXPath(using);
    }

    @Override
    public List<T> findElementsByAccessibilityId(String using) {
        return super.findElementsByAccessibilityId(using);
    }

    public ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    @Deprecated
    public void tap(int fingers, WebElement element, int duration) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int i = 0;
        while (i < fingers) {
            TouchAction tap = new TouchAction(this);
            multiTouch.add(tap.press(element).waitAction(duration).release());
            ++i;
        }
        multiTouch.perform();
    }

    @Deprecated
    public void tap(int fingers, int x, int y, int duration) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int i = 0;
        while (i < fingers) {
            TouchAction tap = new TouchAction(this);
            multiTouch.add(tap.press(x, y).waitAction(duration).release());
            ++i;
        }
        multiTouch.perform();
    }

    @Deprecated
    public void swipe(int startx, int starty, int endx, int endy, int duration) {
    }

    @Deprecated
    public void pinch(WebElement el) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        Dimension dimensions = el.getSize();
        Point upperLeft = el.getLocation();
        Point center = new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
        int yOffset = center.getY() - upperLeft.getY();
        TouchAction action0 = new TouchAction(this).press(el, center.getX(), center.getY() - yOffset).moveTo(el).release();
        TouchAction action1 = new TouchAction(this).press(el, center.getX(), center.getY() + yOffset).moveTo(el).release();
        multiTouch.add(action0).add(action1).perform();
    }

    @Deprecated
    public void pinch(int x, int y) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int scrHeight = this.manage().window().getSize().getHeight();
        int yOffset = 100;
        if (y - 100 < 0) {
            yOffset = y;
        } else if (y + 100 > scrHeight) {
            yOffset = scrHeight - y;
        }
        TouchAction action0 = new TouchAction(this).press(x, y - yOffset).moveTo(x, y).release();
        TouchAction action1 = new TouchAction(this).press(x, y + yOffset).moveTo(x, y).release();
        multiTouch.add(action0).add(action1).perform();
    }

    @Deprecated
    public void zoom(WebElement el) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        Dimension dimensions = el.getSize();
        Point upperLeft = el.getLocation();
        Point center = new Point(upperLeft.getX() + dimensions.getWidth() / 2, upperLeft.getY() + dimensions.getHeight() / 2);
        int yOffset = center.getY() - upperLeft.getY();
        TouchAction action0 = new TouchAction(this).press(center.getX(), center.getY()).moveTo(el, center.getX(), center.getY() - yOffset).release();
        TouchAction action1 = new TouchAction(this).press(center.getX(), center.getY()).moveTo(el, center.getX(), center.getY() + yOffset).release();
        multiTouch.add(action0).add(action1).perform();
    }

    @Deprecated
    public void zoom(int x, int y) {
        MultiTouchAction multiTouch = new MultiTouchAction(this);
        int scrHeight = this.manage().window().getSize().getHeight();
        int yOffset = 100;
        if (y - 100 < 0) {
            yOffset = y;
        } else if (y + 100 > scrHeight) {
            yOffset = scrHeight - y;
        }
        TouchAction action0 = new TouchAction(this).press(x, y).moveTo(0, -yOffset).release();
        TouchAction action1 = new TouchAction(this).press(x, y).moveTo(0, yOffset).release();
        multiTouch.add(action0).add(action1).perform();
    }

    public WebDriver context(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Must supply a context name");
        this.execute("switchToContext", (Map)ImmutableMap.of((Object)"name", (Object)name));
        this.currentContext = name;
        return this;
    }

    public Set<String> getContextHandles() {
        Response response = this.execute("getContextHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, (Throwable)ex);
        }
    }

    public String getContext() {
        String contextName = String.valueOf(this.execute("getCurrentContextHandle").getValue());
        if ("null".equalsIgnoreCase(contextName)) {
            return null;
        }
        return contextName;
    }

    public DeviceRotation rotation() {
        Response response = this.execute("getScreenRotation");
        DeviceRotation deviceRotation = new DeviceRotation((Map)response.getValue());
        if (deviceRotation.getX() < 0 || deviceRotation.getY() < 0 || deviceRotation.getZ() < 0) {
            throw new WebDriverException("Unexpected orientation returned: " + deviceRotation);
        }
        return deviceRotation;
    }

    public void rotate(DeviceRotation rotation) {
        this.execute("setScreenRotation", rotation.parameters());
    }

    public void rotate(ScreenOrientation orientation) {
        this.execute("setScreenOrientation", (Map)ImmutableMap.of((Object)"orientation", (Object)orientation.value().toUpperCase()));
    }

    public ScreenOrientation getOrientation() {
        Response response = this.execute("getScreenOrientation");
        String orientation = response.getValue().toString().toLowerCase();
        if (orientation.equals(ScreenOrientation.LANDSCAPE.value())) {
            return ScreenOrientation.LANDSCAPE;
        }
        if (orientation.equals(ScreenOrientation.PORTRAIT.value())) {
            return ScreenOrientation.PORTRAIT;
        }
        throw new WebDriverException("Unexpected orientation returned: " + orientation);
    }

    public Location location() {
        return this.locationContext.location();
    }

    public void setLocation(Location location) {
        this.locationContext.setLocation(location);
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getPlatformName() {
        return this.platformName;
    }

    @Override
    public String getAutomationName() {
        return this.automationName;
    }

    @Override
    public boolean isBrowser() {
        if (super.isBrowser()) {
            return true;
        }
        return !this.currentContext.toLowerCase().contains("NATIVE_APP".toLowerCase());
    }
}

