/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.Response;

public interface HasSessionDetails
extends ExecutesMethod {
    default public Map<String, Object> getSessionDetails() {
        Response response = this.execute(MobileCommand.GET_SESSION);
        return ImmutableMap.builder().putAll((Map)Map.class.cast(response.getValue())).build();
    }

    default public Object getSessionDetail(String detail) {
        return this.getSessionDetails().get(detail);
    }

    default public String getPlatformName() {
        Object platformName = this.getSessionDetail("platformName");
        return Optional.ofNullable(platformName != null ? String.valueOf(platformName) : null).orElse(null);
    }

    default public String getAutomationName() {
        Object automationName = this.getSessionDetail("automationName");
        return Optional.ofNullable(automationName != null ? String.valueOf(automationName) : null).orElse(null);
    }

    default public boolean isBrowser() {
        Object browserName = this.getSessionDetail("browserName");
        return browserName != null && !StringUtils.isBlank((CharSequence)String.valueOf(browserName));
    }
}

