/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import com.google.common.base.Function;
import io.appium.java_client.pagefactory.ThrowableUtil;
import io.appium.java_client.pagefactory.TimeOutDuration;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

class AppiumElementLocator
implements CacheableLocator {
    private final boolean shouldCache;
    private final By by;
    private final TimeOutDuration timeOutDuration;
    private final TimeOutDuration originalTimeOutDuration;
    private final WebDriver originalWebDriver;
    private final SearchContext searchContext;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;
    private final String exceptionMessageIfElementNotFound;

    public AppiumElementLocator(SearchContext searchContext, By by, boolean shouldCache, TimeOutDuration duration, TimeOutDuration originalDuration, WebDriver originalWebDriver) {
        this.searchContext = searchContext;
        this.shouldCache = shouldCache;
        this.timeOutDuration = duration;
        this.originalTimeOutDuration = originalDuration;
        this.by = by;
        this.originalWebDriver = originalWebDriver;
        this.exceptionMessageIfElementNotFound = "Can't locate an element by this strategy: " + by.toString();
    }

    private void changeImplicitlyWaitTimeOut(long newTimeOut, TimeUnit newTimeUnit) {
        this.originalWebDriver.manage().timeouts().implicitlyWait(newTimeOut, newTimeUnit);
    }

    private <T> T waitFor(Supplier<T> supplier) {
        WaitingFunction function = new WaitingFunction();
        try {
            this.changeImplicitlyWaitTimeOut(0L, TimeUnit.SECONDS);
            FluentWait wait = new FluentWait(supplier).ignoring(NoSuchElementException.class);
            wait.withTimeout(this.timeOutDuration.getTime(), this.timeOutDuration.getTimeUnit());
            Object object = wait.until(function);
            return (T)object;
        }
        catch (TimeoutException e) {
            if (function.foundStaleElementReferenceException != null) {
                throw (StaleElementReferenceException)StaleElementReferenceException.class.cast(function.foundStaleElementReferenceException);
            }
            throw e;
        }
        finally {
            this.changeImplicitlyWaitTimeOut(this.originalTimeOutDuration.getTime(), this.originalTimeOutDuration.getTimeUnit());
        }
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        try {
            WebElement result = this.waitFor(() -> this.searchContext.findElement(this.by));
            if (this.shouldCache) {
                this.cachedElement = result;
            }
            return result;
        }
        catch (StaleElementReferenceException | TimeoutException e) {
            throw new NoSuchElementException(this.exceptionMessageIfElementNotFound, e);
        }
    }

    public List<WebElement> findElements() {
        ArrayList<WebElement> result;
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        try {
            result = this.waitFor(() -> {
                List list = this.searchContext.findElements(this.by);
                if (list.size() > 0) {
                    return list;
                }
                return null;
            });
        }
        catch (StaleElementReferenceException | TimeoutException throwable) {
            result = new ArrayList<WebElement>();
        }
        if (this.shouldCache) {
            this.cachedElementList = result;
        }
        return result;
    }

    @Override
    public boolean isLookUpCached() {
        return this.shouldCache;
    }

    public String toString() {
        return String.format("Located by %s", this.by);
    }

    private static class WaitingFunction<T>
    implements Function<Supplier<T>, T> {
        private Throwable foundStaleElementReferenceException;

        private WaitingFunction() {
        }

        public T apply(Supplier<T> supplier) {
            this.foundStaleElementReferenceException = null;
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                boolean isRootCauseStaleElementReferenceException = false;
                boolean isRootCauseInvalidSelector = ThrowableUtil.isInvalidSelectorRootCause(e);
                if (!isRootCauseInvalidSelector) {
                    isRootCauseStaleElementReferenceException = ThrowableUtil.isStaleElementReferenceException(e);
                }
                if (isRootCauseStaleElementReferenceException) {
                    this.foundStaleElementReferenceException = ThrowableUtil.extractReadableException(e);
                }
                if (!isRootCauseInvalidSelector & !isRootCauseStaleElementReferenceException) {
                    Throwable shouldBeThrown = ThrowableUtil.extractReadableException(e);
                    if (shouldBeThrown != null) {
                        if (NoSuchElementException.class.equals(shouldBeThrown.getClass())) {
                            throw (NoSuchElementException)NoSuchElementException.class.cast(shouldBeThrown);
                        }
                        throw new WebDriverException(shouldBeThrown);
                    }
                    throw new WebDriverException(e);
                }
                return null;
            }
        }
    }
}

