/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.AppiumElementLocator;
import io.appium.java_client.pagefactory.TimeOutDuration;
import io.appium.java_client.pagefactory.WithTimeout;
import io.appium.java_client.pagefactory.bys.builder.AppiumByBuilder;
import io.appium.java_client.pagefactory.locator.CacheableElementLocatorFactory;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;

public class AppiumElementLocatorFactory
implements CacheableElementLocatorFactory {
    private final SearchContext searchContext;
    private final TimeOutDuration duration;
    private final AppiumByBuilder builder;

    public AppiumElementLocatorFactory(SearchContext searchContext, TimeOutDuration duration, AppiumByBuilder builder) {
        this.searchContext = searchContext;
        this.duration = duration;
        this.builder = builder;
    }

    @Override
    @Nullable
    public CacheableLocator createLocator(Field field) {
        return this.createLocator((AnnotatedElement)field);
    }

    @Override
    @Nullable
    public CacheableLocator createLocator(AnnotatedElement annotatedElement) {
        TimeOutDuration customDuration;
        if (annotatedElement.isAnnotationPresent(WithTimeout.class)) {
            WithTimeout withTimeout = annotatedElement.getAnnotation(WithTimeout.class);
            customDuration = new TimeOutDuration(withTimeout.time(), withTimeout.unit());
        } else {
            customDuration = this.duration;
        }
        this.builder.setAnnotated(annotatedElement);
        By byResult = this.builder.buildBy();
        return Optional.ofNullable(byResult).map(by -> new AppiumElementLocator(this.searchContext, (By)by, this.builder.isLookupCached(), customDuration)).orElse(null);
    }
}

