/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByAndroidDataMatcher;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.FindsByAndroidViewTag;
import io.appium.java_client.FindsByCustom;
import io.appium.java_client.FindsByFluentSelector;
import io.appium.java_client.FindsByImage;
import io.appium.java_client.FindsByIosClassChain;
import io.appium.java_client.FindsByIosNSPredicate;
import io.appium.java_client.FindsByWindowsAutomation;
import io.appium.java_client.MobileSelector;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public abstract class MobileBy
extends By {
    private static final String ERROR_TEXT = "The class %s of the given context doesn't implement %s nor %s. Sorry. It is impossible to find something.";
    private final String locatorString;
    private final MobileSelector selector;

    private static IllegalArgumentException formIllegalArgumentException(Class<?> givenClass, Class<?> class1, Class<?> class2) {
        return new IllegalArgumentException(String.format(ERROR_TEXT, givenClass.getCanonicalName(), class1.getCanonicalName(), class2.getCanonicalName()));
    }

    protected MobileBy(MobileSelector selector, String locatorString) {
        if (StringUtils.isBlank((CharSequence)locatorString)) {
            throw new IllegalArgumentException("Must supply a not empty locator value.");
        }
        this.locatorString = locatorString;
        this.selector = selector;
    }

    public List<WebElement> findElements(SearchContext context) {
        return ((FindsByFluentSelector)((Object)context)).findElements(this.selector.toString(), this.getLocatorString());
    }

    public WebElement findElement(SearchContext context) {
        return ((FindsByFluentSelector)((Object)context)).findElement(this.selector.toString(), this.getLocatorString());
    }

    public static By AndroidUIAutomator(String uiautomatorText) {
        return new ByAndroidUIAutomator(uiautomatorText);
    }

    public static By AccessibilityId(String accessibilityId) {
        return new ByAccessibilityId(accessibilityId);
    }

    public static By iOSClassChain(String iOSClassChainString) {
        return new ByIosClassChain(iOSClassChainString);
    }

    public static By androidDataMatcher(String dataMatcherString) {
        return new ByAndroidDataMatcher(dataMatcherString);
    }

    public static By iOSNsPredicateString(String iOSNsPredicateString) {
        return new ByIosNsPredicate(iOSNsPredicateString);
    }

    public static By windowsAutomation(String windowsAutomation) {
        return new ByWindowsAutomation(windowsAutomation);
    }

    public static By AndroidViewTag(String tag) {
        return new ByAndroidViewTag(tag);
    }

    public static By image(String b64Template) {
        return new ByImage(b64Template);
    }

    public static By custom(String selector) {
        return new ByCustom(selector);
    }

    protected String getLocatorString() {
        return this.locatorString;
    }

    public static class ByAccessibilityId
    extends MobileBy
    implements Serializable {
        public ByAccessibilityId(String accessibilityId) {
            super(MobileSelector.ACCESSIBILITY, accessibilityId);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) throws WebDriverException, IllegalArgumentException {
            Class<?> contextClass = context.getClass();
            if (FindsByAccessibilityId.class.isAssignableFrom(contextClass)) {
                return ((FindsByAccessibilityId)FindsByAccessibilityId.class.cast(context)).findElementsByAccessibilityId(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByAccessibilityId.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) throws WebDriverException, IllegalArgumentException {
            Class<?> contextClass = context.getClass();
            if (FindsByAccessibilityId.class.isAssignableFrom(contextClass)) {
                return ((FindsByAccessibilityId)FindsByAccessibilityId.class.cast(context)).findElementByAccessibilityId(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByAccessibilityId.class, FindsByFluentSelector.class);
        }

        public String toString() {
            return "By.AccessibilityId: " + this.getLocatorString();
        }
    }

    public static class ByAndroidDataMatcher
    extends MobileBy
    implements Serializable {
        protected ByAndroidDataMatcher(String locatorString) {
            super(MobileSelector.ANDROID_DATA_MATCHER, locatorString);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByAndroidDataMatcher.class.isAssignableFrom(contextClass)) {
                return ((FindsByAndroidDataMatcher)FindsByAndroidDataMatcher.class.cast(context)).findElementsByAndroidDataMatcher(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByAndroidDataMatcher.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByAndroidDataMatcher.class.isAssignableFrom(contextClass)) {
                return ((FindsByAndroidDataMatcher)FindsByAndroidDataMatcher.class.cast(context)).findElementByAndroidDataMatcher(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByAndroidDataMatcher.class, FindsByFluentSelector.class);
        }

        public String toString() {
            return "By.FindsByAndroidDataMatcher: " + this.getLocatorString();
        }
    }

    public static class ByAndroidUIAutomator
    extends MobileBy
    implements Serializable {
        public ByAndroidUIAutomator(String uiautomatorText) {
            super(MobileSelector.ANDROID_UI_AUTOMATOR, uiautomatorText);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) throws WebDriverException, IllegalArgumentException {
            Class<?> contextClass = context.getClass();
            if (FindsByAndroidUIAutomator.class.isAssignableFrom(contextClass)) {
                return ((FindsByAndroidUIAutomator)FindsByAndroidUIAutomator.class.cast(context)).findElementsByAndroidUIAutomator(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByAndroidUIAutomator.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) throws WebDriverException, IllegalArgumentException {
            Class<?> contextClass = context.getClass();
            if (FindsByAndroidUIAutomator.class.isAssignableFrom(contextClass)) {
                return ((FindsByAndroidUIAutomator)FindsByAndroidUIAutomator.class.cast(context)).findElementByAndroidUIAutomator(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByAndroidUIAutomator.class, FindsByFluentSelector.class);
        }

        public String toString() {
            return "By.AndroidUIAutomator: " + this.getLocatorString();
        }
    }

    public static class ByAndroidViewTag
    extends MobileBy
    implements Serializable {
        public ByAndroidViewTag(String tag) {
            super(MobileSelector.ANDROID_VIEWTAG, tag);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) throws WebDriverException, IllegalArgumentException {
            Class<?> contextClass = context.getClass();
            if (FindsByAndroidViewTag.class.isAssignableFrom(contextClass)) {
                return ((FindsByAndroidViewTag)FindsByAndroidViewTag.class.cast(context)).findElementsByAndroidViewTag(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByAndroidViewTag.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) throws WebDriverException, IllegalArgumentException {
            Class<?> contextClass = context.getClass();
            if (FindsByAndroidViewTag.class.isAssignableFrom(contextClass)) {
                return ((FindsByAndroidViewTag)FindsByAndroidViewTag.class.cast(context)).findElementByAndroidViewTag(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByAndroidViewTag.class, FindsByFluentSelector.class);
        }

        public String toString() {
            return "By.AndroidViewTag: " + this.getLocatorString();
        }
    }

    public static class ByCustom
    extends MobileBy
    implements Serializable {
        protected ByCustom(String selector) {
            super(MobileSelector.CUSTOM, selector);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByCustom.class.isAssignableFrom(contextClass)) {
                return ((FindsByCustom)FindsByCustom.class.cast(context)).findElementsByCustom(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByCustom.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByCustom.class.isAssignableFrom(contextClass)) {
                return ((FindsByCustom)FindsByCustom.class.cast(context)).findElementByCustom(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByCustom.class, FindsByFluentSelector.class);
        }

        public String toString() {
            return "By.Custom: " + this.getLocatorString();
        }
    }

    public static class ByImage
    extends MobileBy
    implements Serializable {
        protected ByImage(String b64Template) {
            super(MobileSelector.IMAGE, b64Template);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByImage.class.isAssignableFrom(contextClass)) {
                return ((FindsByImage)FindsByImage.class.cast(context)).findElementsByImage(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByImage.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByImage.class.isAssignableFrom(contextClass)) {
                return ((FindsByImage)FindsByImage.class.cast(context)).findElementByImage(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByImage.class, FindsByFluentSelector.class);
        }

        public String toString() {
            return "By.Image: " + this.getLocatorString();
        }
    }

    public static class ByIosClassChain
    extends MobileBy
    implements Serializable {
        protected ByIosClassChain(String locatorString) {
            super(MobileSelector.IOS_CLASS_CHAIN, locatorString);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByIosClassChain.class.isAssignableFrom(contextClass)) {
                return ((FindsByIosClassChain)FindsByIosClassChain.class.cast(context)).findElementsByIosClassChain(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByIosClassChain.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByIosClassChain.class.isAssignableFrom(contextClass)) {
                return ((FindsByIosClassChain)FindsByIosClassChain.class.cast(context)).findElementByIosClassChain(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByIosClassChain.class, FindsByFluentSelector.class);
        }

        public String toString() {
            return "By.IosClassChain: " + this.getLocatorString();
        }
    }

    public static class ByIosNsPredicate
    extends MobileBy
    implements Serializable {
        protected ByIosNsPredicate(String locatorString) {
            super(MobileSelector.IOS_PREDICATE_STRING, locatorString);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByIosNSPredicate.class.isAssignableFrom(contextClass)) {
                return ((FindsByIosNSPredicate)FindsByIosNSPredicate.class.cast(context)).findElementsByIosNsPredicate(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByIosNSPredicate.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByIosNSPredicate.class.isAssignableFrom(contextClass)) {
                return ((FindsByIosNSPredicate)FindsByIosNSPredicate.class.cast(context)).findElementByIosNsPredicate(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByIosNSPredicate.class, FindsByFluentSelector.class);
        }

        public String toString() {
            return "By.IosNsPredicate: " + this.getLocatorString();
        }
    }

    public static class ByWindowsAutomation
    extends MobileBy
    implements Serializable {
        protected ByWindowsAutomation(String locatorString) {
            super(MobileSelector.WINDOWS_UI_AUTOMATION, locatorString);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByWindowsAutomation.class.isAssignableFrom(contextClass)) {
                return ((FindsByWindowsAutomation)FindsByWindowsAutomation.class.cast(context)).findElementsByWindowsUIAutomation(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElements(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByWindowsAutomation.class, FindsByFluentSelector.class);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Class<?> contextClass = context.getClass();
            if (FindsByWindowsAutomation.class.isAssignableFrom(contextClass)) {
                return ((FindsByWindowsAutomation)FindsByWindowsAutomation.class.cast(context)).findElementByWindowsUIAutomation(this.getLocatorString());
            }
            if (FindsByFluentSelector.class.isAssignableFrom(contextClass)) {
                return super.findElement(context);
            }
            throw MobileBy.formIllegalArgumentException(contextClass, FindsByIosNSPredicate.class, FindsByWindowsAutomation.class);
        }
    }
}

