/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.AppiumFieldDecorator;
import io.appium.java_client.pagefactory.ThrowableUtil;
import io.appium.java_client.pagefactory.Widget;
import io.appium.java_client.pagefactory.bys.ContentType;
import io.appium.java_client.pagefactory.interceptors.InterceptorOfASingleElement;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import io.appium.java_client.pagefactory.utils.WebDriverUnpackUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class WidgetInterceptor
extends InterceptorOfASingleElement {
    private final Map<ContentType, Constructor<? extends Widget>> instantiationMap;
    private final Map<ContentType, Widget> cachedInstances = new HashMap<ContentType, Widget>();
    private final Duration duration;
    private WebElement cachedElement;

    public WidgetInterceptor(CacheableLocator locator, WebDriver driver, @Nullable WebElement cachedElement, Map<ContentType, Constructor<? extends Widget>> instantiationMap, Duration duration) {
        super(locator, driver);
        this.cachedElement = cachedElement;
        this.instantiationMap = instantiationMap;
        this.duration = duration;
    }

    @Override
    protected Object getObject(WebElement element, Method method, Object[] args) throws Throwable {
        ContentType type = WebDriverUnpackUtility.getCurrentContentType((SearchContext)element);
        if (this.cachedElement == null || this.locator != null && !((CacheableLocator)this.locator).isLookUpCached() || this.cachedInstances.isEmpty()) {
            this.cachedElement = element;
            Constructor<? extends Widget> constructor = this.instantiationMap.get((Object)type);
            Class<? extends Widget> clazz = constructor.getDeclaringClass();
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new InstantiationException(String.format("%s  is abstract so it cannot be instantiated", clazz.getName()));
            }
            Widget widget = constructor.newInstance(this.cachedElement);
            this.cachedInstances.put(type, widget);
            PageFactory.initElements((FieldDecorator)new AppiumFieldDecorator(widget, this.duration), (Object)widget);
        }
        try {
            method.setAccessible(true);
            return method.invoke((Object)this.cachedInstances.get((Object)type), args);
        }
        catch (Throwable t) {
            throw ThrowableUtil.extractReadableException(t);
        }
    }

    @Override
    public Object call(Object obj, Method method, Object[] args, Callable<?> original) throws Throwable {
        return this.locator == null ? this.getObject(this.cachedElement, method, args) : super.call(obj, method, args, original);
    }
}

