/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.geolocation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AndroidGeoLocation {
    private Double longitude;
    private Double latitude;
    private Double altitude;
    private Integer satellites;
    private Double speed;

    public AndroidGeoLocation() {
    }

    public AndroidGeoLocation(double latitude, double longitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public AndroidGeoLocation withLongitude(double longitude) {
        this.longitude = longitude;
        return this;
    }

    public AndroidGeoLocation withLatitude(double latitude) {
        this.latitude = latitude;
        return this;
    }

    public AndroidGeoLocation withAltitude(double altitude) {
        this.altitude = altitude;
        return this;
    }

    public AndroidGeoLocation withSatellites(int satellites) {
        this.satellites = satellites;
        return this;
    }

    public AndroidGeoLocation withSpeed(double speed) {
        this.speed = speed;
        return this;
    }

    public Map<String, ?> build() {
        HashMap map = new HashMap();
        Optional.ofNullable(this.longitude).map(x -> map.put("longitude", x)).orElseThrow(() -> new IllegalArgumentException("A valid 'longitude' must be provided"));
        Optional.ofNullable(this.latitude).map(x -> map.put("latitude", x)).orElseThrow(() -> new IllegalArgumentException("A valid 'latitude' must be provided"));
        Optional.ofNullable(this.altitude).ifPresent(x -> map.put("altitude", x));
        Optional.ofNullable(this.satellites).ifPresent(x -> map.put("satellites", x));
        Optional.ofNullable(this.speed).ifPresent(x -> map.put("speed", x));
        return Collections.unmodifiableMap(map);
    }
}

