/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.nativekey;

import io.appium.java_client.android.nativekey.AndroidKey;
import io.appium.java_client.android.nativekey.KeyEventFlag;
import io.appium.java_client.android.nativekey.KeyEventMetaModifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class KeyEvent {
    private Integer keyCode;
    private Integer metaState;
    private Integer flags;

    public KeyEvent() {
    }

    public KeyEvent(AndroidKey key) {
        this.keyCode = key.getCode();
    }

    public KeyEvent withKey(AndroidKey key) {
        this.keyCode = key.getCode();
        return this;
    }

    public KeyEvent withMetaModifier(KeyEventMetaModifier keyEventMetaModifier) {
        if (this.metaState == null) {
            this.metaState = 0;
        }
        this.metaState = this.metaState | keyEventMetaModifier.getValue();
        return this;
    }

    public KeyEvent withFlag(KeyEventFlag keyEventFlag) {
        if (this.flags == null) {
            this.flags = 0;
        }
        this.flags = this.flags | keyEventFlag.getValue();
        return this;
    }

    public Map<String, Object> build() {
        HashMap map = new HashMap();
        Optional.ofNullable(this.keyCode).map(x -> map.put("keycode", x)).orElseThrow(() -> new IllegalStateException("The key code must be set"));
        Optional.ofNullable(this.metaState).ifPresent(x -> map.put("metastate", x));
        Optional.ofNullable(this.flags).ifPresent(x -> map.put("flags", x));
        return Collections.unmodifiableMap(map);
    }
}

