/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import io.appium.java_client.clipboard.ClipboardContentType;
import io.appium.java_client.clipboard.HasClipboard;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.imageio.ImageIO;

public interface HasIOSClipboard
extends HasClipboard {
    default public void setClipboardImage(BufferedImage img) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)Objects.requireNonNull(img), "png", os);
            this.setClipboard(ClipboardContentType.IMAGE, Base64.getMimeEncoder().encode(os.toByteArray()));
        }
    }

    default public BufferedImage getClipboardImage() throws IOException {
        byte[] base64decodedBytes = Base64.getMimeDecoder().decode(this.getClipboard(ClipboardContentType.IMAGE));
        return ImageIO.read(new ByteArrayInputStream(base64decodedBytes));
    }

    default public void setClipboardUrl(URL url) {
        this.setClipboard(ClipboardContentType.URL, Base64.getMimeEncoder().encode(Objects.requireNonNull(url).toString().getBytes(StandardCharsets.UTF_8)));
    }

    default public URL getClipboardUrl() throws MalformedURLException {
        byte[] base64decodedBytes = Base64.getMimeDecoder().decode(this.getClipboard(ClipboardContentType.URL));
        return new URL(new String(base64decodedBytes, StandardCharsets.UTF_8));
    }
}

