/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Throwables;
import io.appium.java_client.internal.ReflectionHelpers;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;

public class AppiumFluentWait<T>
extends FluentWait<T> {
    private Function<IterationInfo, Duration> pollingStrategy = null;
    private static final Duration DEFAULT_POLL_DELAY_DURATION = Duration.ZERO;
    private Duration pollDelay = DEFAULT_POLL_DELAY_DURATION;

    public AppiumFluentWait(T input) {
        super(input);
    }

    public AppiumFluentWait(T input, Clock clock, Sleeper sleeper) {
        super(input, clock, sleeper);
    }

    public AppiumFluentWait<T> withPollDelay(Duration pollDelay) {
        this.pollDelay = pollDelay;
        return this;
    }

    private <B> B getPrivateFieldValue(String fieldName, Class<B> fieldType) {
        return ReflectionHelpers.getPrivateFieldValue(FluentWait.class, this, fieldName, fieldType);
    }

    private Object getPrivateFieldValue(String fieldName) {
        return this.getPrivateFieldValue(fieldName, Object.class);
    }

    protected Clock getClock() {
        return this.getPrivateFieldValue("clock", Clock.class);
    }

    protected Duration getTimeout() {
        return this.getPrivateFieldValue("timeout", Duration.class);
    }

    protected Duration getInterval() {
        return this.getPrivateFieldValue("interval", Duration.class);
    }

    protected Sleeper getSleeper() {
        return this.getPrivateFieldValue("sleeper", Sleeper.class);
    }

    protected List<Class<? extends Throwable>> getIgnoredExceptions() {
        return this.getPrivateFieldValue("ignoredExceptions", List.class);
    }

    protected Supplier<String> getMessageSupplier() {
        return this.getPrivateFieldValue("messageSupplier", Supplier.class);
    }

    protected T getInput() {
        return (T)this.getPrivateFieldValue("input");
    }

    public AppiumFluentWait<T> withPollingStrategy(Function<IterationInfo, Duration> pollingStrategy) {
        this.pollingStrategy = pollingStrategy;
        return this;
    }

    @Override
    public <V> V until(Function<? super T, V> isTrue) {
        Instant start = this.getClock().instant();
        Instant end = start.plus(this.getTimeout()).plus(this.pollDelay);
        return this.performIteration(isTrue, start, end);
    }

    private <V> V performIteration(Function<? super T, V> isTrue, Instant start, Instant end) {
        int iterationNumber = 1;
        this.sleepInterruptibly(this.pollDelay);
        while (true) {
            Throwable lastException;
            try {
                V value = isTrue.apply(this.getInput());
                if (value != null && (Boolean.class != value.getClass() || Boolean.TRUE.equals(value))) {
                    return value;
                }
                lastException = null;
            }
            catch (Throwable e) {
                lastException = this.propagateIfNotIgnored(e);
            }
            if (end.isBefore(this.getClock().instant())) {
                this.handleTimeoutException(lastException, isTrue);
            }
            Duration interval = this.getIntervalWithPollingStrategy(start, iterationNumber);
            this.sleepInterruptibly(interval);
            ++iterationNumber;
        }
    }

    private <V> void handleTimeoutException(Throwable lastException, Function<? super T, V> isTrue) {
        String message = Optional.ofNullable(this.getMessageSupplier()).map(Supplier::get).orElseGet(() -> "waiting for " + isTrue);
        String timeoutMessage = String.format("Expected condition failed: %s (tried for %s ms with an interval of %s ms)", message, this.getTimeout().toMillis(), this.getInterval().toMillis());
        throw this.timeoutException(timeoutMessage, lastException);
    }

    private Duration getIntervalWithPollingStrategy(Instant start, long iterationNumber) {
        Duration interval = this.getInterval();
        return Optional.ofNullable(this.pollingStrategy).map(strategy -> (Duration)strategy.apply(new IterationInfo(iterationNumber, Duration.between(start, this.getClock().instant()), this.getTimeout(), interval))).orElse(interval);
    }

    private void sleepInterruptibly(Duration duration) {
        try {
            if (!duration.isZero() && !duration.isNegative()) {
                this.getSleeper().sleep(duration);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverException(e);
        }
    }

    protected Throwable propagateIfNotIgnored(Throwable e) {
        for (Class<Throwable> ignoredException : this.getIgnoredExceptions()) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        Throwables.throwIfUnchecked(e);
        throw new WebDriverException(e);
    }

    public static class IterationInfo {
        private final long number;
        private final Duration elapsed;
        private final Duration total;
        private final Duration interval;

        public IterationInfo(long number, Duration elapsed, Duration total, Duration interval) {
            this.number = number;
            this.elapsed = elapsed;
            this.total = total;
            this.interval = interval;
        }

        public long getNumber() {
            return this.number;
        }

        public Duration getElapsed() {
            return this.elapsed;
        }

        public Duration getTotal() {
            return this.total;
        }

        public Duration getInterval() {
            return this.interval;
        }
    }
}

