/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Strings;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.internal.CapabilityHelpers;
import java.util.Objects;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriverException;

public interface HasBrowserCheck
extends ExecutesMethod,
HasCapabilities {
    default public boolean isBrowser() {
        String browserName = CapabilityHelpers.getCapability(this.getCapabilities(), "browserName", String.class);
        if (!Strings.isNullOrEmpty(browserName)) {
            try {
                return Objects.requireNonNull((Boolean)CommandExecutionHelper.executeScript(this, "return !!window.navigator;"));
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
        if (!(this instanceof ContextAware)) {
            return false;
        }
        try {
            String context = ((ContextAware)((Object)this)).getContext();
            return context != null && !context.toUpperCase().contains("NATIVE_APP");
        }
        catch (WebDriverException e) {
            return false;
        }
    }
}

