/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.appmanagement;

import com.google.common.base.Preconditions;
import io.appium.java_client.appmanagement.BaseInstallApplicationOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AndroidInstallApplicationOptions
extends BaseInstallApplicationOptions<AndroidInstallApplicationOptions> {
    private Boolean replace;
    private Duration timeout;
    private Boolean allowTestPackages;
    private Boolean useSdcard;
    private Boolean grantPermissions;

    public AndroidInstallApplicationOptions withReplaceEnabled() {
        this.replace = true;
        return this;
    }

    public AndroidInstallApplicationOptions withReplaceDisabled() {
        this.replace = false;
        return this;
    }

    public AndroidInstallApplicationOptions withTimeout(Duration timeout) {
        Preconditions.checkArgument(!Objects.requireNonNull(timeout).isNegative(), "The timeout value cannot be negative");
        this.timeout = timeout;
        return this;
    }

    public AndroidInstallApplicationOptions withAllowTestPackagesEnabled() {
        this.allowTestPackages = true;
        return this;
    }

    public AndroidInstallApplicationOptions withAllowTestPackagesDisabled() {
        this.allowTestPackages = false;
        return this;
    }

    public AndroidInstallApplicationOptions withUseSdcardEnabled() {
        this.useSdcard = true;
        return this;
    }

    public AndroidInstallApplicationOptions withUseSdcardDisabled() {
        this.useSdcard = false;
        return this;
    }

    public AndroidInstallApplicationOptions withGrantPermissionsEnabled() {
        this.grantPermissions = true;
        return this;
    }

    public AndroidInstallApplicationOptions withGrantPermissionsDisabled() {
        this.grantPermissions = false;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        HashMap map = new HashMap();
        Optional.ofNullable(this.replace).ifPresent(x -> map.put("replace", x));
        Optional.ofNullable(this.timeout).ifPresent(x -> map.put("timeout", x.toMillis()));
        Optional.ofNullable(this.allowTestPackages).ifPresent(x -> map.put("allowTestPackages", x));
        Optional.ofNullable(this.useSdcard).ifPresent(x -> map.put("useSdcard", x));
        Optional.ofNullable(this.grantPermissions).ifPresent(x -> map.put("grantPermissions", x));
        return Collections.unmodifiableMap(map);
    }
}

