/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal.filters;

import java.util.UUID;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;

public class AppiumIdempotencyFilter
implements Filter {
    private static final String IDEMPOTENCY_KEY_HEADER = "X-Idempotency-Key";

    @Override
    public HttpHandler apply(HttpHandler next) {
        return req -> {
            if (req.getMethod() == HttpMethod.POST && req.getUri().endsWith("/session")) {
                req.setHeader(IDEMPOTENCY_KEY_HEADER, UUID.randomUUID().toString().toLowerCase());
            }
            return next.execute(req);
        };
    }
}

