/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.ws.StringWebSocketClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import org.openqa.selenium.remote.RemoteWebDriver;

public interface ListensToSyslogMessages
extends ExecutesMethod {
    public StringWebSocketClient getSyslogClient();

    default public void startSyslogBroadcast() {
        this.startSyslogBroadcast("localhost", 4723);
    }

    default public void startSyslogBroadcast(String host) {
        this.startSyslogBroadcast(host, 4723);
    }

    default public void startSyslogBroadcast(String host, int port) {
        URI endpointUri;
        CommandExecutionHelper.executeScript(this, "mobile: startLogsBroadcast");
        try {
            endpointUri = new URI(String.format("ws://%s:%s/ws/session/%s/appium/device/syslog", host, port, ((RemoteWebDriver)((Object)this)).getSessionId()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.getSyslogClient().connect(endpointUri);
    }

    default public void addSyslogMessagesListener(Consumer<String> handler) {
        this.getSyslogClient().addMessageHandler(handler);
    }

    default public void addSyslogErrorsListener(Consumer<Throwable> handler) {
        this.getSyslogClient().addErrorHandler(handler);
    }

    default public void addSyslogConnectionListener(Runnable handler) {
        this.getSyslogClient().addConnectionHandler(handler);
    }

    default public void addSyslogDisconnectionListener(Runnable handler) {
        this.getSyslogClient().addDisconnectionHandler(handler);
    }

    default public void removeAllSyslogListeners() {
        this.getSyslogClient().removeAllHandlers();
    }

    default public void stopSyslogBroadcast() {
        CommandExecutionHelper.executeScript(this, "mobile: stopLogsBroadcast");
    }
}

