/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import com.google.common.base.Preconditions;
import io.appium.java_client.internal.CapabilityHelpers;
import io.appium.java_client.pagefactory.AppiumElementLocatorFactory;
import io.appium.java_client.pagefactory.DefaultElementByBuilder;
import io.appium.java_client.pagefactory.ElementInterceptor;
import io.appium.java_client.pagefactory.ElementListInterceptor;
import io.appium.java_client.pagefactory.OverrideWidgetReader;
import io.appium.java_client.pagefactory.Widget;
import io.appium.java_client.pagefactory.WidgetByBuilder;
import io.appium.java_client.pagefactory.WidgetConstructorUtil;
import io.appium.java_client.pagefactory.WidgetInterceptor;
import io.appium.java_client.pagefactory.WidgetListInterceptor;
import io.appium.java_client.pagefactory.bys.ContentType;
import io.appium.java_client.pagefactory.bys.builder.AppiumByBuilder;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import io.appium.java_client.pagefactory.utils.ProxyFactory;
import io.appium.java_client.pagefactory.utils.WebDriverUnpackUtility;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class AppiumFieldDecorator
implements FieldDecorator {
    private static final List<Class<? extends WebElement>> AVAILABLE_ELEMENT_CLASSES = List.of(WebElement.class, RemoteWebElement.class);
    public static final Duration DEFAULT_WAITING_TIMEOUT = Duration.ofSeconds(1L);
    private final WeakReference<WebDriver> webDriverReference;
    private final DefaultFieldDecorator defaultElementFieldDecorator;
    private final AppiumElementLocatorFactory widgetLocatorFactory;
    private final String platform;
    private final String automation;
    private final Duration duration;

    public AppiumFieldDecorator(SearchContext context, Duration duration) {
        this.webDriverReference = AppiumFieldDecorator.requireWebDriverReference(context);
        this.platform = this.readStringCapability(context, "platformName");
        this.automation = this.readStringCapability(context, "automationName");
        this.duration = duration;
        this.defaultElementFieldDecorator = this.createFieldDecorator(new AppiumElementLocatorFactory(context, duration, (AppiumByBuilder)new DefaultElementByBuilder(this.platform, this.automation)));
        this.widgetLocatorFactory = new AppiumElementLocatorFactory(context, duration, (AppiumByBuilder)new WidgetByBuilder(this.platform, this.automation));
    }

    public AppiumFieldDecorator(SearchContext context) {
        this(context, DEFAULT_WAITING_TIMEOUT);
    }

    AppiumFieldDecorator(WeakReference<SearchContext> contextReference, Duration duration) {
        SearchContext cr = (SearchContext)contextReference.get();
        this.webDriverReference = AppiumFieldDecorator.requireWebDriverReference(cr);
        this.platform = this.readStringCapability(cr, "platformName");
        this.automation = this.readStringCapability(cr, "automationName");
        this.duration = duration;
        this.defaultElementFieldDecorator = this.createFieldDecorator(new AppiumElementLocatorFactory(contextReference, duration, (AppiumByBuilder)new DefaultElementByBuilder(this.platform, this.automation)));
        this.widgetLocatorFactory = new AppiumElementLocatorFactory(contextReference, duration, (AppiumByBuilder)new WidgetByBuilder(this.platform, this.automation));
    }

    @Nonnull
    private static WeakReference<WebDriver> requireWebDriverReference(SearchContext searchContext) {
        Optional<WebDriver> wd = WebDriverUnpackUtility.unpackObjectFromSearchContext(Preconditions.checkNotNull(searchContext, "The provided search context cannot be null"), WebDriver.class);
        return wd.map(WeakReference::new).orElseThrow(() -> new IllegalArgumentException(String.format("No driver implementing %s interface could be extracted from the %s instance. Is the provided search context valid?", WebDriver.class.getName(), searchContext.getClass().getName())));
    }

    @Nullable
    private String readStringCapability(SearchContext searchContext, String capName) {
        if (searchContext == null) {
            return null;
        }
        return WebDriverUnpackUtility.unpackObjectFromSearchContext(searchContext, HasCapabilities.class).map(HasCapabilities::getCapabilities).map(caps -> CapabilityHelpers.getCapability(caps, capName, String.class)).orElse(null);
    }

    private DefaultFieldDecorator createFieldDecorator(ElementLocatorFactory factory) {
        return new DefaultFieldDecorator(factory){

            @Override
            protected WebElement proxyForLocator(ClassLoader ignored, ElementLocator locator) {
                return AppiumFieldDecorator.this.proxyForAnElement(locator);
            }

            @Override
            protected List<WebElement> proxyForListLocator(ClassLoader ignored, ElementLocator locator) {
                ElementListInterceptor elementInterceptor = new ElementListInterceptor(locator);
                return ProxyFactory.getEnhancedProxy(ArrayList.class, elementInterceptor);
            }

            @Override
            protected boolean isDecoratableList(Field field) {
                if (!List.class.isAssignableFrom(field.getType())) {
                    return false;
                }
                Type genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType)) {
                    return false;
                }
                Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                List bounds = listType instanceof TypeVariable ? Arrays.asList(((TypeVariable)listType).getBounds()) : Collections.emptyList();
                return AVAILABLE_ELEMENT_CLASSES.stream().anyMatch(webElClass -> webElClass.equals(listType) || bounds.contains(webElClass));
            }
        };
    }

    @Override
    public Object decorate(ClassLoader ignored, Field field) {
        Object result = this.defaultElementFieldDecorator.decorate(ignored, field);
        return result == null ? this.decorateWidget(field) : result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private Object decorateWidget(Field field) {
        Class widgetType;
        Class<?> type = field.getType();
        if (!Widget.class.isAssignableFrom(type) && !List.class.isAssignableFrom(type)) {
            return null;
        }
        boolean isAlist = false;
        if (List.class.isAssignableFrom(type)) {
            isAlist = true;
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                return null;
            }
            Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (ParameterizedType.class.isAssignableFrom(listType.getClass())) {
                listType = ((ParameterizedType)listType).getRawType();
            }
            if (!(listType instanceof Class)) return null;
            if (!Widget.class.isAssignableFrom((Class)listType)) {
                return null;
            }
            widgetType = (Class)listType;
        } else {
            widgetType = field.getType();
        }
        CacheableLocator locator = this.widgetLocatorFactory.createLocator(field);
        Map<ContentType, Constructor<? extends Widget>> map = OverrideWidgetReader.read(widgetType, field, this.platform);
        if (isAlist) {
            return ProxyFactory.getEnhancedProxy(ArrayList.class, new WidgetListInterceptor(locator, this.webDriverReference, map, widgetType, this.duration));
        }
        Constructor<? extends Widget> constructor = WidgetConstructorUtil.findConvenientConstructor(widgetType);
        return ProxyFactory.getEnhancedProxy(widgetType, new Class[]{constructor.getParameterTypes()[0]}, new Object[]{this.proxyForAnElement(locator)}, new WidgetInterceptor(locator, this.webDriverReference, null, map, this.duration));
    }

    private WebElement proxyForAnElement(ElementLocator locator) {
        ElementInterceptor elementInterceptor = new ElementInterceptor(locator, this.webDriverReference);
        return ProxyFactory.getEnhancedProxy(RemoteWebElement.class, elementInterceptor);
    }
}

