/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.proxy;

import com.google.common.base.Preconditions;
import io.appium.java_client.proxy.HasMethodCallListeners;
import io.appium.java_client.proxy.Interceptor;
import io.appium.java_client.proxy.MethodCallListener;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Helpers {
    public static final Set<String> OBJECT_METHOD_NAMES = Stream.of(Object.class.getMethods()).map(Method::getName).collect(Collectors.toSet());
    private static final ConcurrentMap<ProxyClassSignature, Class<?>> CACHED_PROXY_CLASSES = new ConcurrentHashMap();

    private Helpers() {
    }

    public static <T> T createProxy(Class<T> cls, Object[] constructorArgs, Class<?>[] constructorArgTypes, Collection<MethodCallListener> listeners) {
        ElementMatcher.Junction<MethodDescription> extraMatcher = ElementMatchers.not(ElementMatchers.namedOneOf(OBJECT_METHOD_NAMES.toArray(new String[0])));
        return Helpers.createProxy(cls, constructorArgs, constructorArgTypes, listeners, extraMatcher);
    }

    public static <T> T createProxy(Class<T> cls, Object[] constructorArgs, Class<?>[] constructorArgTypes, Collection<MethodCallListener> listeners, @Nullable ElementMatcher<MethodDescription> extraMethodMatcher) {
        ProxyClassSignature signature = ProxyClassSignature.of(cls, constructorArgTypes, extraMethodMatcher);
        Class proxyClass = CACHED_PROXY_CLASSES.computeIfAbsent(signature, k -> {
            Preconditions.checkArgument(constructorArgs.length == constructorArgTypes.length, String.format("Constructor arguments array length %d must be equal to the types array length %d", constructorArgs.length, constructorArgTypes.length));
            Preconditions.checkArgument(!listeners.isEmpty(), "The collection of listeners must not be empty");
            Objects.requireNonNull(cls, "Class must not be null");
            Preconditions.checkArgument(!cls.isInterface(), "Class must not be an interface");
            ElementMatcher.Junction matcher = ElementMatchers.isPublic();
            return new ByteBuddy().subclass(cls).method(extraMethodMatcher == null ? matcher : matcher.and(extraMethodMatcher)).intercept(MethodDelegation.to(Interceptor.class)).defineField("methodCallListeners", (Type)((Object)MethodCallListener[].class), Visibility.PRIVATE).implement(new Type[]{HasMethodCallListeners.class}).intercept(FieldAccessor.ofBeanProperty()).make().load(Helpers.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded().asSubclass(cls);
        });
        try {
            T result = cls.cast(proxyClass.getConstructor(constructorArgTypes).newInstance(constructorArgs));
            ((HasMethodCallListeners)result).setMethodCallListeners((MethodCallListener[])listeners.toArray(MethodCallListener[]::new));
            return result;
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(String.format("Unable to create a proxy of %s", cls.getName()), e);
        }
    }

    public static <T> T createProxy(Class<T> cls, Collection<MethodCallListener> listeners) {
        return Helpers.createProxy(cls, new Object[0], new Class[0], listeners);
    }

    public static <T> T createProxy(Class<T> cls, MethodCallListener listener) {
        return Helpers.createProxy(cls, new Object[0], new Class[0], Collections.singletonList(listener));
    }

    public static <T> T createProxy(Class<T> cls, Object[] constructorArgs, Class<?>[] constructorArgTypes, MethodCallListener listener) {
        return Helpers.createProxy(cls, constructorArgs, constructorArgTypes, Collections.singletonList(listener));
    }

    private static final class ProxyClassSignature {
        private final Class<?> cls;
        private final Class<?>[] constructorArgTypes;
        private final ElementMatcher<MethodDescription> extraMethodMatcher;

        private ProxyClassSignature(Class<?> cls, Class<?>[] constructorArgTypes, ElementMatcher<MethodDescription> extraMethodMatcher) {
            this.cls = cls;
            this.constructorArgTypes = constructorArgTypes;
            this.extraMethodMatcher = extraMethodMatcher;
        }

        public static ProxyClassSignature of(Class<?> cls, Class<?>[] constructorArgTypes, ElementMatcher<MethodDescription> extraMethodMatcher) {
            return new ProxyClassSignature(cls, constructorArgTypes, extraMethodMatcher);
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public Class<?>[] getConstructorArgTypes() {
            return this.constructorArgTypes;
        }

        public ElementMatcher<MethodDescription> getExtraMethodMatcher() {
            return this.extraMethodMatcher;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyClassSignature)) {
                return false;
            }
            ProxyClassSignature other = (ProxyClassSignature)o;
            Class<?> this$cls = this.getCls();
            Class<?> other$cls = other.getCls();
            if (this$cls == null ? other$cls != null : !this$cls.equals(other$cls)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getConstructorArgTypes(), other.getConstructorArgTypes())) {
                return false;
            }
            ElementMatcher<MethodDescription> this$extraMethodMatcher = this.getExtraMethodMatcher();
            ElementMatcher<MethodDescription> other$extraMethodMatcher = other.getExtraMethodMatcher();
            return !(this$extraMethodMatcher == null ? other$extraMethodMatcher != null : !this$extraMethodMatcher.equals(other$extraMethodMatcher));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $cls = this.getCls();
            result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getConstructorArgTypes());
            ElementMatcher<MethodDescription> $extraMethodMatcher = this.getExtraMethodMatcher();
            result = result * 59 + ($extraMethodMatcher == null ? 43 : $extraMethodMatcher.hashCode());
            return result;
        }

        public String toString() {
            return "Helpers.ProxyClassSignature(cls=" + this.getCls() + ", constructorArgTypes=" + Arrays.deepToString(this.getConstructorArgTypes()) + ", extraMethodMatcher=" + this.getExtraMethodMatcher() + ")";
        }
    }
}

