/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote.options;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class BaseMapOptionData<T extends BaseMapOptionData<T>> {
    private Map<String, Object> options;
    private static final Gson GSON = new Gson();

    public BaseMapOptionData() {
    }

    public BaseMapOptionData(Map<String, Object> options) {
        this.options = options;
    }

    public BaseMapOptionData(String json) {
        this(GSON.fromJson(json, Map.class));
    }

    public T assignOptionValue(String key, Object value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(key, value);
        return (T)this;
    }

    public <R> Optional<R> getOptionValue(String name) {
        return Optional.ofNullable(this.options).map(opts -> opts.getOrDefault(name, null));
    }

    public Map<String, Object> toMap() {
        return Optional.ofNullable(this.options).orElseGet(Collections::emptyMap);
    }

    public JsonObject toJson() {
        return GSON.toJsonTree(this.toMap()).getAsJsonObject();
    }

    public String toString() {
        return GSON.toJson(this.toMap());
    }
}

