/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import com.google.common.base.Strings;
import io.appium.java_client.service.local.AppiumServerAvailabilityChecker;
import io.appium.java_client.service.local.AppiumServerHasNotBeenStartedLocallyException;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.ListOutputStream;
import io.appium.java_client.service.local.Slf4jLogMessageContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.openqa.selenium.os.ExternalProcess;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class AppiumDriverLocalService
extends DriverService {
    private static final String URL_MASK = "http://%s:%d/";
    private static final Logger LOG = LoggerFactory.getLogger(AppiumDriverLocalService.class);
    private static final Pattern LOGGER_CONTEXT_PATTERN = Pattern.compile("^(\\[debug\\] )?\\[(.+?)\\]");
    private static final String APPIUM_SERVICE_SLF4J_LOGGER_PREFIX = "appium.service";
    private static final Duration DESTROY_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration IS_RUNNING_PING_TIMEOUT = Duration.ofMillis(1500L);
    private final File nodeJSExec;
    private final List<String> nodeJSArgs;
    private final Map<String, String> nodeJSEnvironment;
    private final Duration startupTimeout;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ListOutputStream stream = new ListOutputStream().add(System.out);
    private final AppiumServerAvailabilityChecker availabilityChecker = new AppiumServerAvailabilityChecker();
    private final URL url;
    private String basePath;
    private ExternalProcess process = null;

    AppiumDriverLocalService(String ipAddress, File nodeJSExec, int nodeJSPort, Duration startupTimeout, List<String> nodeJSArgs, Map<String, String> nodeJSEnvironment) throws IOException {
        super(nodeJSExec, nodeJSPort, startupTimeout, nodeJSArgs, nodeJSEnvironment);
        this.nodeJSExec = nodeJSExec;
        this.nodeJSArgs = nodeJSArgs;
        this.nodeJSEnvironment = nodeJSEnvironment;
        this.startupTimeout = startupTimeout;
        this.url = new URL(String.format(URL_MASK, ipAddress, nodeJSPort));
    }

    public static AppiumDriverLocalService buildDefaultService() {
        return AppiumDriverLocalService.buildService(new AppiumServiceBuilder());
    }

    public static AppiumDriverLocalService buildService(AppiumServiceBuilder builder) {
        return (AppiumDriverLocalService)builder.build();
    }

    public AppiumDriverLocalService withBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    private static URL addSuffix(URL url, String suffix) {
        return url.toURI().resolve("." + (String)(suffix.startsWith("/") ? suffix : "/" + suffix)).toURL();
    }

    private static URL replaceHost(URL source, String oldHost, String newHost) {
        return new URL(source.toString().replaceFirst(oldHost, newHost));
    }

    @Override
    public URL getUrl() {
        return this.basePath == null ? this.url : AppiumDriverLocalService.addSuffix(this.url, this.basePath);
    }

    @Override
    public boolean isRunning() {
        this.lock.lock();
        try {
            if (this.process == null || !this.process.isAlive()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.ping(IS_RUNNING_PING_TIMEOUT);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean ping(Duration timeout) throws InterruptedException {
        URL baseURL = this.fixBroadcastAddresses(this.getUrl());
        URL statusUrl = AppiumDriverLocalService.addSuffix(baseURL, "/status");
        return this.availabilityChecker.waitUntilAvailable(statusUrl, timeout);
    }

    private URL fixBroadcastAddresses(URL url) {
        String host = url.getHost();
        if (host.equals("0.0.0.0")) {
            return AppiumDriverLocalService.replaceHost(url, "0.0.0.0", "127.0.0.1");
        }
        if (host.equals("::")) {
            return AppiumDriverLocalService.replaceHost(url, "::", "::1");
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws AppiumServerHasNotBeenStartedLocallyException {
        this.lock.lock();
        try {
            if (this.isRunning()) {
                return;
            }
            try {
                ExternalProcess.Builder processBuilder = ExternalProcess.builder().command(this.nodeJSExec.getCanonicalPath(), this.nodeJSArgs).copyOutputTo(this.stream);
                this.nodeJSEnvironment.forEach(processBuilder::environment);
                this.process = processBuilder.start();
            }
            catch (IOException e) {
                throw new AppiumServerHasNotBeenStartedLocallyException(e);
            }
            boolean didPingSucceed = false;
            try {
                this.ping(this.startupTimeout);
                didPingSucceed = true;
            }
            catch (AppiumServerAvailabilityChecker.ConnectionError | AppiumServerAvailabilityChecker.ConnectionTimeout e) {
                ArrayList<String> errorLines = new ArrayList<String>(this.generateDetailedErrorMessagePrefix(e));
                errorLines.addAll(this.retrieveServerDebugInfo());
                throw new AppiumServerHasNotBeenStartedLocallyException(String.join((CharSequence)"\n", errorLines), e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!didPingSucceed) {
                    this.destroyProcess();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<String> generateDetailedErrorMessagePrefix(RuntimeException e) {
        ArrayList<String> errorLines = new ArrayList<String>();
        if (e instanceof AppiumServerAvailabilityChecker.ConnectionTimeout) {
            errorLines.add(String.format("Appium HTTP server is not listening at %s after %s ms timeout. Consider increasing the server startup timeout value and check the server log for possible error messages occurrences.", this.getUrl(), ((AppiumServerAvailabilityChecker.ConnectionTimeout)e).getTimeout().toMillis()));
        } else if (e instanceof AppiumServerAvailabilityChecker.ConnectionError) {
            AppiumServerAvailabilityChecker.ConnectionError connectionError = (AppiumServerAvailabilityChecker.ConnectionError)e;
            int statusCode = connectionError.getResponseCode();
            URL statusUrl = connectionError.getStatusUrl();
            Optional<String> payload = connectionError.getPayload();
            errorLines.add(String.format("Appium HTTP server has started and is listening although we were unable to get an OK response from %s. Make sure both the client and the server use the same base path '%s' and check the server log for possible error messages occurrences.", statusUrl, Optional.ofNullable(this.basePath).orElse("/")));
            errorLines.add(String.format("Response status code: %s", statusCode));
            payload.ifPresent(p -> errorLines.add(String.format("Response payload: %s", p)));
        }
        return errorLines;
    }

    private List<String> retrieveServerDebugInfo() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.format("Node.js executable path: %s", this.nodeJSExec.getAbsolutePath()));
        result.add(String.format("Arguments: %s", this.nodeJSArgs));
        Optional.ofNullable(this.process).map(ExternalProcess::getOutput).filter(o -> !Strings.isNullOrEmpty(o)).ifPresent(o -> result.add(String.format("Server log: %s", o)));
        return result;
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            if (this.process != null) {
                this.destroyProcess();
            }
            this.process = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void destroyProcess() {
        if (this.process == null || !this.process.isAlive()) {
            return;
        }
        this.process.shutdown(DESTROY_TIMEOUT);
    }

    @Nullable
    public String getStdOut() {
        return Optional.ofNullable(this.process).map(ExternalProcess::getOutput).orElse(null);
    }

    public void addOutPutStream(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream parameter is NULL!");
        this.stream.add(outputStream);
    }

    public void addOutPutStreams(List<OutputStream> outputStreams) {
        Objects.requireNonNull(outputStreams, "outputStreams parameter is NULL!");
        for (OutputStream outputStream : outputStreams) {
            this.addOutPutStream(outputStream);
        }
    }

    public Optional<OutputStream> removeOutPutStream(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream parameter is NULL!");
        return this.stream.remove(outputStream);
    }

    public boolean clearOutPutStreams() {
        return this.stream.clear();
    }

    public void enableDefaultSlf4jLoggingOfOutputData() {
        this.addSlf4jLogMessageConsumer((logMessage, ctx) -> {
            if (ctx.getLevel().equals((Object)Level.DEBUG)) {
                ctx.getLogger().debug((String)logMessage);
            } else {
                ctx.getLogger().info((String)logMessage);
            }
        });
    }

    public void addSlf4jLogMessageConsumer(BiConsumer<String, Slf4jLogMessageContext> slf4jLogMessageConsumer) {
        Objects.requireNonNull(slf4jLogMessageConsumer, "slf4jLogMessageConsumer parameter is NULL!");
        this.addLogMessageConsumer(logMessage -> slf4jLogMessageConsumer.accept((String)logMessage, AppiumDriverLocalService.parseSlf4jContextFromLogMessage(logMessage)));
    }

    private static Slf4jLogMessageContext parseSlf4jContextFromLogMessage(String logMessage) {
        Matcher m4 = LOGGER_CONTEXT_PATTERN.matcher(logMessage);
        Object loggerName = APPIUM_SERVICE_SLF4J_LOGGER_PREFIX;
        Level level = Level.INFO;
        if (m4.find()) {
            loggerName = (String)loggerName + "." + m4.group(2).toLowerCase().replaceAll("\\s+", "");
            if (m4.group(1) != null) {
                level = Level.DEBUG;
            }
        }
        return new Slf4jLogMessageContext((String)loggerName, level);
    }

    public void addLogMessageConsumer(final Consumer<String> consumer) {
        Objects.requireNonNull(consumer, "consumer parameter is NULL!");
        this.addOutPutStream(new OutputStream(){
            private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

            @Override
            public void write(int chr) {
                try {
                    this.outputStream.write(chr);
                    if (chr == 10) {
                        consumer.accept(this.outputStream.toString());
                        this.outputStream.reset();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Log message consumer crashed!", e);
                }
            }
        });
    }

    public String getBasePath() {
        return this.basePath;
    }
}

