/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.touch;

import com.google.common.base.Preconditions;
import io.appium.java_client.touch.ActionOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;

public class WaitOptions
extends ActionOptions<WaitOptions> {
    protected Duration duration = Duration.ofMillis(0L);

    public static WaitOptions waitOptions(Duration duration) {
        return new WaitOptions().withDuration(duration);
    }

    public WaitOptions withDuration(Duration duration) {
        Objects.requireNonNull(duration);
        Preconditions.checkArgument(duration.toMillis() >= 0L, "Duration value should be greater or equal to zero");
        this.duration = duration;
        return this;
    }

    @Override
    protected void verify() {
    }

    @Override
    public Map<String, Object> build() {
        Map<String, Object> result = super.build();
        result.put("ms", this.duration.toMillis());
        return result;
    }
}

