/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ws;

import io.appium.java_client.ws.CanHandleConnects;
import io.appium.java_client.ws.CanHandleDisconnects;
import io.appium.java_client.ws.CanHandleErrors;
import io.appium.java_client.ws.CanHandleMessages;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.WebSocket;

public class StringWebSocketClient
implements WebSocket.Listener,
CanHandleMessages<String>,
CanHandleErrors,
CanHandleConnects,
CanHandleDisconnects {
    private final List<Consumer<String>> messageHandlers = new CopyOnWriteArrayList<Consumer<String>>();
    private final List<Consumer<Throwable>> errorHandlers = new CopyOnWriteArrayList<Consumer<Throwable>>();
    private final List<Runnable> connectHandlers = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> disconnectHandlers = new CopyOnWriteArrayList<Runnable>();
    private volatile boolean isListening = false;
    private final WeakReference<HttpClient> httpClient;
    private URI endpoint;

    public StringWebSocketClient(HttpClient httpClient) {
        this.httpClient = new WeakReference<HttpClient>(httpClient);
    }

    private void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Nullable
    public URI getEndpoint() {
        return this.endpoint;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void connect(URI endpoint) {
        if (endpoint.equals(this.getEndpoint()) && this.isListening) {
            return;
        }
        HttpRequest request = new HttpRequest(HttpMethod.GET, endpoint.toString());
        Objects.requireNonNull((HttpClient)this.httpClient.get()).openSocket(request, this);
        this.onOpen();
        this.setEndpoint(endpoint);
    }

    public void onOpen() {
        try {
            this.getConnectionHandlers().forEach(Runnable::run);
        }
        finally {
            this.isListening = true;
        }
    }

    @Override
    public void onClose(int code, String reason) {
        try {
            this.getDisconnectionHandlers().forEach(Runnable::run);
        }
        finally {
            this.isListening = false;
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.getErrorHandlers().forEach(x -> x.accept(t2));
    }

    @Override
    public void onText(CharSequence data) {
        String text = data.toString();
        this.getMessageHandlers().forEach(x -> x.accept(text));
    }

    @Override
    public List<Consumer<String>> getMessageHandlers() {
        return this.messageHandlers;
    }

    @Override
    public List<Consumer<Throwable>> getErrorHandlers() {
        return this.errorHandlers;
    }

    @Override
    public List<Runnable> getConnectionHandlers() {
        return this.connectHandlers;
    }

    @Override
    public List<Runnable> getDisconnectionHandlers() {
        return this.disconnectHandlers;
    }

    public void removeAllHandlers() {
        this.removeMessageHandlers();
        this.removeErrorHandlers();
        this.removeConnectionHandlers();
        this.removeDisconnectionHandlers();
    }
}

