/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.CircularOutputStream;
import org.openqa.selenium.io.MultiOutputStream;

public class ExternalProcess {
    private static final Logger LOG = Logger.getLogger(ExternalProcess.class.getName());
    private final Process process;
    private final CircularOutputStream outputStream;
    private final Thread worker;

    public static Builder builder() {
        return new Builder();
    }

    public ExternalProcess(Process process, CircularOutputStream outputStream, Thread worker) {
        this.process = process;
        this.outputStream = outputStream;
        this.worker = worker;
    }

    public String getOutput() {
        return this.outputStream.toString();
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(Duration duration) throws InterruptedException {
        boolean exited = this.process.waitFor(duration.toMillis(), TimeUnit.MILLISECONDS);
        if (exited) {
            try {
                this.worker.join(8000L);
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
            }
            finally {
                this.worker.interrupt();
                try {
                    this.worker.join(2000L);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
            }
        }
        return exited;
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public void shutdown() {
        this.shutdown(Duration.ofSeconds(4L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(Duration timeout) {
        try {
            if (this.process.supportsNormalTermination()) {
                this.process.destroy();
                try {
                    if (this.process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                        return;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
            }
            this.process.destroyForcibly();
            try {
                this.process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
                return;
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                return;
            }
        }
        finally {
            try {
                this.worker.join(8000L);
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
            }
            finally {
                this.worker.interrupt();
                try {
                    this.worker.join(2000L);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
            }
        }
    }

    public static class Builder {
        private ProcessBuilder builder = new ProcessBuilder(new String[0]);
        private OutputStream copyOutputTo;
        private int bufferSize = 32768;

        Builder() {
        }

        public Builder command(String executable, List<String> arguments) {
            ArrayList<String> command = new ArrayList<String>(arguments.size() + 1);
            command.add(executable);
            command.addAll(arguments);
            this.builder.command(command);
            return this;
        }

        public Builder command(List<String> command) {
            this.builder.command(command);
            return this;
        }

        public Builder command(String ... command) {
            this.builder.command(command);
            return this;
        }

        public List<String> command() {
            return Collections.unmodifiableList(this.builder.command());
        }

        public Builder environment(String name, String value) {
            Require.argument("name", name).nonNull();
            Require.argument("value", value).nonNull();
            this.builder.environment().put(name, value);
            return this;
        }

        public Map<String, String> environment() {
            return this.builder.environment();
        }

        public File directory() {
            return this.builder.directory();
        }

        public Builder directory(String directory) {
            return this.directory(new File(directory));
        }

        public Builder directory(File directory) {
            this.builder.directory(directory);
            return this;
        }

        public Builder copyOutputTo(OutputStream stream) {
            this.copyOutputTo = stream;
            return this;
        }

        public Builder bufferSize(int toKeep) {
            this.bufferSize = toKeep;
            return this;
        }

        public ExternalProcess start() throws UncheckedIOException {
            Process process;
            this.builder.redirectErrorStream(true);
            try {
                process = this.builder.start();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            try {
                CircularOutputStream circular = new CircularOutputStream(this.bufferSize);
                Thread worker = new Thread(() -> {
                    MultiOutputStream output = new MultiOutputStream(circular, this.copyOutputTo);
                    InputStream input = process.getInputStream();
                    try {
                        input.transferTo(output);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, "failed to copy the output of process " + process.pid(), ex);
                    }
                    LOG.log(Level.FINE, "completed to copy the output of process " + process.pid());
                }, "External Process Output Forwarder - " + (this.builder.command().isEmpty() ? "N/A" : this.builder.command().get(0)));
                worker.setDaemon(true);
                worker.start();
                return new ExternalProcess(process, circular, worker);
            }
            catch (Throwable t2) {
                try {
                    process.destroyForcibly();
                }
                catch (Throwable t22) {
                    t2.addSuppressed(t22);
                }
                throw t2;
            }
        }
    }
}

