/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

public final class Capability {
    private static final long CLIENT_MYSQL = 1L;
    private static final long FOUND_ROWS = 2L;
    private static final long LONG_FLAG = 4L;
    private static final long CONNECT_WITH_DB = 8L;
    private static final long NO_SCHEMA = 16L;
    private static final long COMPRESS = 32L;
    private static final long LOCAL_FILES = 128L;
    private static final long IGNORE_SPACE = 256L;
    private static final long PROTOCOL_41 = 512L;
    private static final long INTERACTIVE = 1024L;
    private static final long SSL = 2048L;
    private static final long TRANSACTIONS = 8192L;
    private static final long SECURE_SALT = 32768L;
    private static final long MULTI_STATEMENTS = 65536L;
    private static final long MULTI_RESULTS = 131072L;
    private static final long PS_MULTI_RESULTS = 262144L;
    private static final long PLUGIN_AUTH = 524288L;
    private static final long CONNECT_ATTRS = 0x100000L;
    private static final long VAR_INT_SIZED_AUTH = 0x200000L;
    private static final long DEPRECATE_EOF = 0x1000000L;
    private static final long ALL_SUPPORTED = 20950975L;
    private final long bitmap;

    public boolean isMariaDb() {
        return (this.bitmap & 1L) == 0L;
    }

    public boolean isConnectWithDatabase() {
        return (this.bitmap & 8L) != 0L;
    }

    public boolean isSslEnabled() {
        return (this.bitmap & 0x800L) != 0L;
    }

    public boolean isProtocol41() {
        return (this.bitmap & 0x200L) != 0L;
    }

    public boolean isVarIntSizedAuthAllowed() {
        return (this.bitmap & 0x200000L) != 0L;
    }

    public boolean isPluginAuthAllowed() {
        return (this.bitmap & 0x80000L) != 0L;
    }

    public boolean isConnectionAttributesAllowed() {
        return (this.bitmap & 0x100000L) != 0L;
    }

    public boolean isMultiStatementsAllowed() {
        return (this.bitmap & 0x10000L) != 0L;
    }

    public boolean isEofDeprecated() {
        return (this.bitmap & 0x1000000L) != 0L;
    }

    public boolean isSaltSecured() {
        return (this.bitmap & 0x8000L) != 0L;
    }

    public boolean isTransactionAllowed() {
        return (this.bitmap & 0x2000L) != 0L;
    }

    public Capability extendMariaDb(long hiCapabilities) {
        return Capability.of(this.bitmap & 0xFFFFFFFFL | hiCapabilities << 32);
    }

    public int getBaseBitmap() {
        return (int)this.bitmap;
    }

    public int getExtendBitmap() {
        return (int)(this.bitmap >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capability)) {
            return false;
        }
        Capability that = (Capability)o;
        return this.bitmap == that.bitmap;
    }

    public int hashCode() {
        return Long.hashCode(this.bitmap);
    }

    public String toString() {
        return "Capability<0x" + Long.toHexString(this.bitmap) + '>';
    }

    Builder mutate() {
        return new Builder(this.bitmap);
    }

    private Capability(long bitmap) {
        this.bitmap = bitmap;
    }

    public static Capability of(long capabilities) {
        return new Capability(capabilities & 0x13FAFBFL);
    }

    static final class Builder {
        private long bitmap;

        void disableConnectWithDatabase() {
            this.bitmap &= 0xFFFFFFFFFFFFFFF7L;
        }

        void disableDatabasePinned() {
            this.bitmap &= 0xFFFFFFFFFFFFFFEFL;
        }

        void disableCompression() {
            this.bitmap &= 0xFFFFFFFFFFFFFFDFL;
        }

        void disableLoadDataInfile() {
            this.bitmap &= 0xFFFFFFFFFFFFFF7FL;
        }

        void disableIgnoreAmbiguitySpace() {
            this.bitmap &= 0xFFFFFFFFFFFFFEFFL;
        }

        void disableInteractiveTimeout() {
            this.bitmap &= 0xFFFFFFFFFFFFFBFFL;
        }

        void disableSsl() {
            this.bitmap &= 0xFFFFFFFFFFFFF7FFL;
        }

        void disableConnectAttributes() {
            this.bitmap &= 0xFFFFFFFFFFEFFFFFL;
        }

        Capability build() {
            return Capability.of(this.bitmap);
        }

        private Builder(long bitmap) {
            this.bitmap = bitmap;
        }
    }
}

