/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Binding;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.MySqlResult;
import io.asyncer.r2dbc.mysql.MySqlStatement;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.SimpleStatementSupport;
import io.asyncer.r2dbc.mysql.cache.PrepareCache;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Flux;

final class PrepareSimpleStatement
extends SimpleStatementSupport {
    private static final List<Binding> BINDINGS = Collections.singletonList(new Binding(0));
    private final PrepareCache prepareCache;
    private int fetchSize = 0;

    PrepareSimpleStatement(Client client, Codecs codecs, ConnectionContext context, String sql, PrepareCache prepareCache) {
        super(client, codecs, context, sql);
        this.prepareCache = prepareCache;
    }

    @Override
    public Flux<MySqlResult> execute() {
        return QueryFlow.execute(this.client, this.sql, BINDINGS, this.fetchSize, this.prepareCache).map(messages -> MySqlResult.toResult(true, this.codecs, this.context, this.generatedKeyName, (Flux<ServerMessage>)messages));
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = rows;
        return this;
    }
}

