/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoSink;

final class RequestTask<T> {
    @Nullable
    private final Disposable disposable;
    private final MonoSink<T> sink;
    private final T supplier;
    private volatile boolean isCancelled;

    private RequestTask(@Nullable Disposable disposable, MonoSink<T> sink, T supplier) {
        this.disposable = disposable;
        this.sink = sink;
        this.supplier = supplier;
    }

    void run() {
        this.sink.success(this.supplier);
    }

    void cancel(Throwable e) {
        this.cancel0();
        this.sink.error(e);
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    private void cancel0() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.isCancelled = true;
    }

    static <T> RequestTask<T> wrap(ClientMessage message, MonoSink<T> sink, T supplier) {
        RequestTask task = message instanceof Disposable ? new RequestTask<T>((Disposable)message, sink, supplier) : new RequestTask(null, sink, supplier);
        sink.onCancel(() -> task.cancel0());
        return task;
    }

    static <T> RequestTask<T> wrap(Flux<? extends ClientMessage> messages, MonoSink<T> sink, T supplier) {
        RequestTask task = new RequestTask(new DisposableFlux(messages), sink, supplier);
        sink.onCancel(() -> task.cancel0());
        return task;
    }

    static <T> RequestTask<T> wrap(MonoSink<T> sink, T supplier) {
        RequestTask task = new RequestTask(null, sink, supplier);
        sink.onCancel(() -> task.cancel0());
        return task;
    }

    private static final class DisposableFlux
    implements Disposable {
        private final Flux<? extends ClientMessage> messages;

        private DisposableFlux(Flux<? extends ClientMessage> messages) {
            this.messages = messages;
        }

        public void dispose() {
            Flux.from(this.messages).subscribe(it -> {
                if (it instanceof Disposable) {
                    ((Disposable)it).dispose();
                }
            });
        }
    }
}

