/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.OperatorUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ParamWriter
extends ParameterWriter {
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Consumer<MySqlParameter> DISPOSE = MySqlParameter::dispose;
    private final StringBuilder builder;
    private final Query query;
    private int index;
    private Mode mode;

    private ParamWriter(Query query) {
        this.builder = ParamWriter.newBuilder(query);
        this.query = query;
        this.index = 1;
        this.mode = 1 < query.getPartSize() ? Mode.AVAILABLE : Mode.FULL;
    }

    @Override
    public void writeNull() {
        this.startAvailable(Mode.NULL);
        this.builder.append("NULL");
    }

    @Override
    public void writeInt(int value) {
        this.startAvailable(Mode.NUMERIC);
        this.builder.append(value);
    }

    @Override
    public void writeLong(long value) {
        this.startAvailable(Mode.NUMERIC);
        this.builder.append(value);
    }

    @Override
    public void writeUnsignedLong(long value) {
        this.startAvailable(Mode.NUMERIC);
        this.builder.append(Long.toUnsignedString(value));
    }

    @Override
    public void writeBigInteger(BigInteger value) {
        AssertUtils.requireNonNull(value, "value must not be null");
        this.startAvailable(Mode.NUMERIC);
        this.builder.append(value);
    }

    @Override
    public void writeFloat(float value) {
        this.startAvailable(Mode.NUMERIC);
        this.builder.append(value);
    }

    @Override
    public void writeDouble(double value) {
        this.startAvailable(Mode.NUMERIC);
        this.builder.append(value);
    }

    @Override
    public void writeBigDecimal(BigDecimal value) {
        AssertUtils.requireNonNull(value, "value must not be null");
        this.startAvailable(Mode.NUMERIC);
        this.builder.append(value);
    }

    @Override
    public void writeBinary(boolean bit) {
        this.startAvailable(Mode.BINARY);
        this.builder.append(bit ? (char)'1' : '0');
    }

    @Override
    public void startHex() {
        this.startAvailable(Mode.HEX);
    }

    @Override
    public void writeHex(ByteBuffer buffer) {
        AssertUtils.requireNonNull(buffer, "buffer must not be null");
        this.startAvailable(Mode.HEX);
        int limit = buffer.limit();
        for (int i = buffer.position(); i < limit; ++i) {
            byte b = buffer.get(i);
            this.builder.append(HEX_CHAR[(b & 0xF0) >>> 4]).append(HEX_CHAR[b & 0xF]);
        }
    }

    @Override
    public void writeHex(byte[] bytes) {
        AssertUtils.requireNonNull(bytes, "bytes must not be null");
        this.startAvailable(Mode.HEX);
        for (byte b : bytes) {
            this.builder.append(HEX_CHAR[(b & 0xF0) >>> 4]).append(HEX_CHAR[b & 0xF]);
        }
    }

    @Override
    public void writeHex(long bits) {
        this.startAvailable(Mode.HEX);
        this.builder.append(Long.toHexString(bits));
    }

    @Override
    public void startString() {
        this.startAvailable(Mode.STRING);
    }

    @Override
    public void write(int c) {
        this.startAvailable(Mode.STRING);
        this.escape((char)c);
    }

    @Override
    public ParameterWriter append(char c) {
        this.startAvailable(Mode.STRING);
        this.escape(c);
        return this;
    }

    @Override
    public ParameterWriter append(@Nullable CharSequence csq) {
        CharSequence s = csq == null ? "null" : csq;
        return this.append0(s, 0, s.length());
    }

    @Override
    public ParameterWriter append(@Nullable CharSequence csq, int start, int end) {
        CharSequence s;
        CharSequence charSequence = s = csq == null ? "null" : csq;
        if (start < 0 || start > s.length() || end < start || end > s.length()) {
            throw new IndexOutOfBoundsException("start: " + start + ", end: " + end + ", str length: " + s.length());
        }
        return this.append0(s, start, end);
    }

    @Override
    public void write(@Nullable String str) {
        String s = str == null ? "null" : str;
        this.write0(s, 0, s.length());
    }

    @Override
    public void write(@Nullable String str, int off, int len) {
        String s;
        String string = s = str == null ? "null" : str;
        if (off < 0 || off > s.length() || len < 0 || off + len > s.length() || off + len < 0) {
            throw new IndexOutOfBoundsException("off: " + off + ", len: " + len + ", str length: " + s.length());
        }
        this.write0(s, off, len);
    }

    @Override
    public void write(@Nullable char[] c) {
        if (c == null) {
            this.write((String)null);
            return;
        }
        this.write0(c, 0, c.length);
    }

    @Override
    public void write(@Nullable char[] c, int off, int len) {
        if (c == null) {
            this.write((String)null, off, len);
            return;
        }
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off: " + off + ", len: " + len + ", chars length: " + c.length);
        }
        this.write0(c, off, len);
    }

    private String toSql() {
        if (this.mode != Mode.FULL) {
            throw new IllegalStateException("Unexpected completion, parameters are not filled");
        }
        return this.builder.toString();
    }

    private void startAvailable(Mode mode) {
        Mode current = this.mode;
        if (current == Mode.AVAILABLE) {
            this.mode = mode;
            mode.start(this.builder);
            return;
        }
        if (current.canFollow(mode)) {
            return;
        }
        if (current == Mode.FULL) {
            throw new IllegalStateException("Unexpected write, parameters are filled-up");
        }
        throw new IllegalStateException("Unexpected write, mode is " + (Object)((Object)current) + ", write with " + (Object)((Object)mode));
    }

    private void flushParameter(Void ignored) {
        Mode current = this.mode;
        switch (current) {
            case FULL: {
                return;
            }
            case AVAILABLE: {
                this.builder.append('\'').append('\'');
                break;
            }
            default: {
                current.end(this.builder);
            }
        }
        this.query.partTo(this.builder, this.index++);
        this.mode = this.index < this.query.getPartSize() ? Mode.AVAILABLE : Mode.FULL;
    }

    private ParamWriter append0(CharSequence csq, int start, int end) {
        this.startAvailable(Mode.STRING);
        for (int i = start; i < end; ++i) {
            this.escape(csq.charAt(i));
        }
        return this;
    }

    private void write0(String s, int off, int len) {
        this.startAvailable(Mode.STRING);
        int end = len + off;
        for (int i = off; i < end; ++i) {
            this.escape(s.charAt(i));
        }
    }

    private void write0(char[] s, int off, int len) {
        this.startAvailable(Mode.STRING);
        int end = len + off;
        for (int i = off; i < end; ++i) {
            this.escape(s[i]);
        }
    }

    private void escape(char c) {
        switch (c) {
            case '\\': {
                this.builder.append('\\').append('\\');
                break;
            }
            case '\'': {
                this.builder.append('\'').append('\'');
                break;
            }
            case '\u0000': {
                this.builder.append('\\').append('0');
                break;
            }
            case '\u001a': {
                this.builder.append('\\').append('Z');
                break;
            }
            case '\n': {
                this.builder.append('\\').append('n');
                break;
            }
            case '\r': {
                this.builder.append('\\').append('r');
                break;
            }
            default: {
                this.builder.append(c);
            }
        }
    }

    static Mono<String> publish(Query query, Flux<MySqlParameter> values) {
        return Mono.defer(() -> {
            ParamWriter writer = new ParamWriter(query);
            return OperatorUtils.discardOnCancel(values).doOnDiscard(MySqlParameter.class, DISPOSE).concatMap(it -> it.publishText(writer).doOnSuccess(writer::flushParameter)).then(Mono.fromCallable(writer::toSql));
        });
    }

    private static StringBuilder newBuilder(Query query) {
        StringBuilder builder = new StringBuilder(Math.min(query.getFormattedSize(), 64));
        query.partTo(builder, 0);
        return builder;
    }

    private static enum Mode {
        AVAILABLE,
        FULL,
        NULL{

            @Override
            boolean canFollow(Mode mode) {
                return false;
            }
        }
        ,
        NUMERIC{

            @Override
            boolean canFollow(Mode mode) {
                return false;
            }
        }
        ,
        BINARY{

            @Override
            void start(StringBuilder builder) {
                builder.append('b').append('\'');
            }

            @Override
            void end(StringBuilder builder) {
                builder.append('\'');
            }
        }
        ,
        HEX{

            @Override
            void start(StringBuilder builder) {
                builder.append('x').append('\'');
            }

            @Override
            void end(StringBuilder builder) {
                builder.append('\'');
            }
        }
        ,
        STRING{

            @Override
            boolean canFollow(Mode mode) {
                return this == mode || mode == NUMERIC;
            }

            @Override
            void start(StringBuilder builder) {
                builder.append('\'');
            }

            @Override
            void end(StringBuilder builder) {
                builder.append('\'');
            }
        };


        void start(StringBuilder builder) {
        }

        void end(StringBuilder builder) {
        }

        boolean canFollow(Mode mode) {
            return this == mode;
        }
    }
}

