/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.atomix.primitive.partition;

import io.atomix.utils.event.ListenerService;

import java.util.Collection;

/**
 * Partition group membership service.
 */
public interface PartitionGroupMembershipService extends ListenerService<PartitionGroupMembershipEvent, PartitionGroupMembershipEventListener> {

  /**
   * Returns the system group membership.
   *
   * @return the system group membership
   */
  PartitionGroupMembership getSystemMembership();

  /**
   * Returns the members for the given group.
   *
   * @param group the group for which to return the members
   * @return the members for the given group
   */
  PartitionGroupMembership getMembership(String group);

  /**
   * Returns the membership for all partition groups.
   *
   * @return the membership for all partition groups
   */
  Collection<PartitionGroupMembership> getMemberships();

}
