/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.AbstractBytes;
import io.atomix.catalyst.buffer.Bytes;
import java.nio.ByteOrder;

public class WrappedBytes
extends AbstractBytes {
    protected final Bytes bytes;
    private final Bytes root;

    public WrappedBytes(Bytes bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes cannot be null");
        }
        this.bytes = bytes;
        this.root = bytes instanceof WrappedBytes ? ((WrappedBytes)bytes).root : bytes;
    }

    public Bytes root() {
        return this.root;
    }

    @Override
    public long size() {
        return this.bytes.size();
    }

    @Override
    public Bytes resize(long newSize) {
        return this.bytes.resize(newSize);
    }

    @Override
    public ByteOrder order() {
        return this.bytes.order();
    }

    @Override
    public Bytes zero() {
        this.bytes.zero();
        return this;
    }

    @Override
    public Bytes zero(long offset) {
        this.bytes.zero(offset);
        return this;
    }

    @Override
    public Bytes zero(long offset, long length) {
        this.bytes.zero(offset, length);
        return this;
    }

    @Override
    public Bytes read(long offset, Bytes dst, long dstOffset, long length) {
        this.bytes.read(offset, dst, dstOffset, length);
        return this;
    }

    @Override
    public Bytes read(long offset, byte[] dst, long dstOffset, long length) {
        this.bytes.read(offset, dst, dstOffset, length);
        return this;
    }

    @Override
    public int readByte(long offset) {
        return this.bytes.readByte(offset);
    }

    @Override
    public int readUnsignedByte(long offset) {
        return this.bytes.readUnsignedByte(offset);
    }

    @Override
    public char readChar(long offset) {
        return this.bytes.readChar(offset);
    }

    @Override
    public short readShort(long offset) {
        return this.bytes.readShort(offset);
    }

    @Override
    public int readUnsignedShort(long offset) {
        return this.bytes.readUnsignedShort(offset);
    }

    @Override
    public int readMedium(long offset) {
        return this.bytes.readMedium(offset);
    }

    @Override
    public int readUnsignedMedium(long offset) {
        return this.bytes.readUnsignedMedium(offset);
    }

    @Override
    public int readInt(long offset) {
        return this.bytes.readInt(offset);
    }

    @Override
    public long readUnsignedInt(long offset) {
        return this.bytes.readUnsignedInt(offset);
    }

    @Override
    public long readLong(long offset) {
        return this.bytes.readLong(offset);
    }

    @Override
    public float readFloat(long offset) {
        return this.bytes.readFloat(offset);
    }

    @Override
    public double readDouble(long offset) {
        return this.bytes.readDouble(offset);
    }

    @Override
    public boolean readBoolean(long offset) {
        return this.bytes.readBoolean(offset);
    }

    @Override
    public String readString(long offset) {
        return this.bytes.readString(offset);
    }

    @Override
    public String readUTF8(long offset) {
        return this.bytes.readUTF8(offset);
    }

    @Override
    public Bytes write(long offset, Bytes src, long srcOffset, long length) {
        this.bytes.write(offset, src, srcOffset, length);
        return this;
    }

    @Override
    public Bytes write(long offset, byte[] src, long srcOffset, long length) {
        this.bytes.write(offset, src, srcOffset, length);
        return this;
    }

    @Override
    public Bytes writeByte(long offset, int b) {
        this.bytes.writeByte(offset, b);
        return this;
    }

    @Override
    public Bytes writeUnsignedByte(long offset, int b) {
        this.bytes.writeUnsignedByte(offset, b);
        return this;
    }

    @Override
    public Bytes writeChar(long offset, char c) {
        this.bytes.writeChar(offset, c);
        return this;
    }

    @Override
    public Bytes writeShort(long offset, short s) {
        this.bytes.writeShort(offset, s);
        return this;
    }

    @Override
    public Bytes writeUnsignedShort(long offset, int s) {
        this.bytes.writeUnsignedShort(offset, s);
        return this;
    }

    @Override
    public Bytes writeMedium(long offset, int m) {
        this.bytes.writeMedium(offset, m);
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(long offset, int m) {
        this.bytes.writeUnsignedMedium(offset, m);
        return this;
    }

    @Override
    public Bytes writeInt(long offset, int i) {
        this.bytes.writeInt(offset, i);
        return this;
    }

    @Override
    public Bytes writeUnsignedInt(long offset, long i) {
        this.bytes.writeUnsignedInt(offset, i);
        return this;
    }

    @Override
    public Bytes writeLong(long offset, long l) {
        this.bytes.writeLong(offset, l);
        return this;
    }

    @Override
    public Bytes writeFloat(long offset, float f) {
        this.bytes.writeFloat(offset, f);
        return this;
    }

    @Override
    public Bytes writeDouble(long offset, double d) {
        this.bytes.writeDouble(offset, d);
        return this;
    }

    @Override
    public Bytes writeBoolean(long offset, boolean b) {
        this.bytes.writeBoolean(offset, b);
        return this;
    }

    @Override
    public Bytes writeString(long offset, String s) {
        this.bytes.writeString(offset, s);
        return this;
    }

    @Override
    public Bytes writeUTF8(long offset, String s) {
        this.bytes.writeUTF8(offset, s);
        return this;
    }

    @Override
    public Bytes flush() {
        this.bytes.flush();
        return this;
    }

    @Override
    public void close() {
        this.bytes.close();
    }
}

