/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.AbstractBuffer;
import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.ByteBufferBytes;
import io.atomix.catalyst.util.reference.ReferenceManager;

public class ByteBufferBuffer
extends AbstractBuffer {
    protected final ByteBufferBytes bytes;

    public ByteBufferBuffer(ByteBufferBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
        this.bytes = bytes;
    }

    public ByteBufferBuffer(ByteBufferBytes bytes, long offset, long initialCapacity, long maxCapacity, ReferenceManager<Buffer> referenceManager) {
        super(bytes, offset, initialCapacity, maxCapacity, referenceManager);
        this.bytes = bytes;
    }

    @Override
    public byte[] array() {
        return this.bytes.array();
    }

    @Override
    protected void compact(long from, long to, long length) {
        long size;
        byte[] bytes = new byte[1024];
        for (long position = from; position < from + length; position += size) {
            size = Math.min(from + length - position, 1024L);
            this.bytes.read(position, bytes, 0L, size);
            this.bytes.write(0L, bytes, 0L, size);
        }
    }
}

