/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.Response;
import java.util.Collection;
import java.util.Objects;

public class ConnectResponse
extends AbstractResponse {
    private Address leader;
    private Collection<Address> members;

    public static Builder builder() {
        return new Builder(new ConnectResponse());
    }

    public static Builder builder(ConnectResponse response) {
        return new Builder(response);
    }

    public Address leader() {
        return this.leader;
    }

    public Collection<Address> members() {
        return this.members;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.leader = (Address)serializer.readObject(buffer);
            this.members = (Collection)serializer.readObject(buffer);
        } else {
            this.error = CopycatError.forId(buffer.readByte());
        }
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeByte((int)this.status.id());
        if (this.status == Response.Status.OK) {
            serializer.writeObject((Object)this.leader, buffer);
            serializer.writeObject(this.members, buffer);
        } else {
            buffer.writeByte((int)this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.leader, this.members});
    }

    public boolean equals(Object object) {
        if (object instanceof ConnectResponse) {
            ConnectResponse response = (ConnectResponse)object;
            return response.status == this.status && (response.leader == null && this.leader == null || response.leader != null && this.leader != null && response.leader.equals((Object)this.leader)) && (response.members == null && this.members == null || response.members != null && this.members != null && response.members.equals(this.members));
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, leader=%s, members=%s]", new Object[]{this.getClass().getSimpleName(), this.status, this.leader, this.members});
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, ConnectResponse> {
        protected Builder(ConnectResponse response) {
            super(response);
        }

        public Builder withLeader(Address leader) {
            ((ConnectResponse)this.response).leader = leader;
            return this;
        }

        public Builder withMembers(Collection<Address> members) {
            ((ConnectResponse)this.response).members = (Collection)Assert.notNull(members, (String)"members");
            return this;
        }

        @Override
        public ConnectResponse build() {
            super.build();
            Assert.stateNot((((ConnectResponse)this.response).status == Response.Status.OK && ((ConnectResponse)this.response).members == null ? 1 : 0) != 0, (String)"members cannot be null", (Object[])new Object[0]);
            return (ConnectResponse)this.response;
        }
    }
}

