/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.sql;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.persist.ErrorGenerator;
import io.ballerina.stdlib.persist.sql.ModuleUtils;

public class Utils {
    private static BObject createPersistSQLStream(BStream sqlStream, BTypedesc targetType, BArray fields, BArray includes, BArray typeDescriptions, BObject persistClient, BError persistError) {
        return ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"PersistSQLStream", (Object[])new Object[]{sqlStream, targetType, fields, includes, typeDescriptions, persistClient, persistError});
    }

    private static BStream createPersistSQLStreamValue(BTypedesc targetType, BObject persistSQLStream) {
        RecordType streamConstraint = (RecordType)TypeUtils.getReferredType((Type)targetType.getDescribingType());
        return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)persistSQLStream);
    }

    public static BStream createPersistSQLStreamValue(BStream sqlStream, BTypedesc targetType, BArray fields, BArray includes, BArray typeDescriptions, BObject persistClient, BError persistError) {
        BObject persistSQLStream = Utils.createPersistSQLStream(sqlStream, targetType, fields, includes, typeDescriptions, persistClient, persistError);
        return Utils.createPersistSQLStreamValue(targetType, persistSQLStream);
    }

    public static BError wrapSQLError(BError sqlError) {
        return ErrorGenerator.getBasicPersistError((String)sqlError.getErrorMessage().toString());
    }

    public static BObject createPersistNativeSQLStream(BStream sqlStream, BError error) {
        return ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"PersistNativeSQLStream", (Object[])new Object[]{sqlStream, error});
    }
}

