/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.sql.datastore;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Future;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.async.Callback;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ErrorType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import io.ballerina.stdlib.persist.Constants;
import io.ballerina.stdlib.persist.ErrorGenerator;
import io.ballerina.stdlib.persist.ModuleUtils;
import io.ballerina.stdlib.persist.Utils;
import io.ballerina.stdlib.sql.nativeimpl.ExecuteProcessor;
import io.ballerina.stdlib.sql.nativeimpl.QueryProcessor;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractResultParameterProcessor;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractStatementParameterProcessor;
import io.ballerina.stdlib.sql.parameterprocessor.DefaultResultParameterProcessor;
import io.ballerina.stdlib.sql.parameterprocessor.DefaultStatementParameterProcessor;
import java.util.Map;

public class SQLProcessor {
    private SQLProcessor() {
    }

    static BStream query(Environment env, BObject client, final BTypedesc targetType, BObject whereClause, BObject orderByClause, BObject limitClause, BObject groupByClause) {
        BString entity = Utils.getEntity((Environment)env);
        final BObject persistClient = Utils.getPersistClient((BObject)client, (BString)entity);
        BArray keyFields = (BArray)persistClient.get(Constants.KEY_FIELDS);
        RecordType recordType = (RecordType)targetType.getDescribingType();
        RecordType recordTypeWithIdFields = Utils.getRecordTypeWithKeyFields((BArray)keyFields, (RecordType)recordType);
        BTypedesc targetTypeWithIdFields = ValueCreator.createTypedescValue((Type)recordTypeWithIdFields);
        StreamType streamTypeWithIdFields = TypeCreator.createStreamType((Type)recordTypeWithIdFields, (Type)PredefinedTypes.TYPE_NULL);
        Map trxContextProperties = Utils.getTransactionContextProperties();
        String strandName = env.getStrandName().isPresent() ? (String)env.getStrandName().get() : null;
        BArray[] metadata = Utils.getMetadata((RecordType)recordType);
        final BArray fields = metadata[0];
        final BArray includes = metadata[1];
        final BArray typeDescriptions = metadata[2];
        final Future balFuture = env.markAsync();
        env.getRuntime().invokeMethodAsyncSequentially(persistClient, "runReadQuery", strandName, env.getStrandMetadata(), new Callback(){

            public void notifySuccess(Object o) {
                if (o instanceof BStream) {
                    BStream sqlStream = (BStream)o;
                    balFuture.complete((Object)io.ballerina.stdlib.persist.sql.Utils.createPersistSQLStreamValue(sqlStream, targetType, fields, includes, typeDescriptions, persistClient, null));
                } else {
                    balFuture.complete((Object)io.ballerina.stdlib.persist.sql.Utils.createPersistSQLStreamValue(null, targetType, fields, includes, typeDescriptions, persistClient, (BError)o));
                }
            }

            public void notifyFailure(BError bError) {
                balFuture.complete((Object)io.ballerina.stdlib.persist.sql.Utils.createPersistSQLStreamValue(null, targetType, fields, includes, typeDescriptions, persistClient, ErrorGenerator.wrapError((BError)bError)));
            }
        }, trxContextProperties, (Type)streamTypeWithIdFields, new Object[]{targetTypeWithIdFields, true, fields, true, includes, true, whereClause, true, orderByClause, true, limitClause, true, groupByClause, true});
        return null;
    }

    static Object queryOne(Environment env, BObject client, BArray path, BTypedesc targetType) {
        BString entity = Utils.getEntity((Environment)env);
        BObject persistClient = Utils.getPersistClient((BObject)client, (BString)entity);
        BArray keyFields = (BArray)persistClient.get(Constants.KEY_FIELDS);
        RecordType recordType = (RecordType)targetType.getDescribingType();
        Map trxContextProperties = Utils.getTransactionContextProperties();
        String strandName = env.getStrandName().isPresent() ? (String)env.getStrandName().get() : null;
        RecordType recordTypeWithIdFields = Utils.getRecordTypeWithKeyFields((BArray)keyFields, (RecordType)recordType);
        BTypedesc targetTypeWithIdFields = ValueCreator.createTypedescValue((Type)recordTypeWithIdFields);
        ErrorType persistErrorType = TypeCreator.createErrorType((String)"Error", (Module)ModuleUtils.getModule());
        UnionType unionType = TypeCreator.createUnionType((Type[])new Type[]{recordTypeWithIdFields, persistErrorType});
        BArray[] metadata = Utils.getMetadata((RecordType)recordType);
        BArray fields = metadata[0];
        BArray includes = metadata[1];
        BArray typeDescriptions = metadata[2];
        Object key = Utils.getKey((Environment)env, (BArray)path);
        final Future balFuture = env.markAsync();
        env.getRuntime().invokeMethodAsyncSequentially(Utils.getPersistClient((BObject)client, (BString)entity), "runReadByKeyQuery", strandName, env.getStrandMetadata(), new Callback(){

            public void notifySuccess(Object o) {
                balFuture.complete(o);
            }

            public void notifyFailure(BError bError) {
                balFuture.complete((Object)ErrorGenerator.wrapError((BError)bError));
            }
        }, trxContextProperties, (Type)unionType, new Object[]{targetType, true, targetTypeWithIdFields, true, key, true, fields, true, includes, true, typeDescriptions, true});
        return null;
    }

    static BStream queryNativeSQL(Environment env, BObject client, BObject paramSQLString, BTypedesc targetType) {
        TransactionResourceManager trxResourceManager = TransactionResourceManager.getInstance();
        if (!io.ballerina.stdlib.sql.utils.Utils.isWithinTrxBlock((TransactionResourceManager)trxResourceManager)) {
            return SQLProcessor.queryNativeSQLBal(env, client, paramSQLString, targetType);
        }
        BObject dbClient = (BObject)client.get(io.ballerina.stdlib.persist.sql.Constants.DB_CLIENT);
        BStream sqlStream = QueryProcessor.nativeQuery((Environment)env, (BObject)dbClient, (BObject)paramSQLString, (Object)targetType, (AbstractStatementParameterProcessor)DefaultStatementParameterProcessor.getInstance(), (AbstractResultParameterProcessor)DefaultResultParameterProcessor.getInstance());
        if (sqlStream != null) {
            BObject persistNativeStream = io.ballerina.stdlib.persist.sql.Utils.createPersistNativeSQLStream(sqlStream, null);
            RecordType streamConstraint = (RecordType)TypeUtils.getReferredType((Type)targetType.getDescribingType());
            return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)persistNativeStream);
        }
        return null;
    }

    static Object executeNativeSQL(Environment env, BObject client, BObject paramSQLString) {
        TransactionResourceManager trxResourceManager = TransactionResourceManager.getInstance();
        if (!io.ballerina.stdlib.sql.utils.Utils.isWithinTrxBlock((TransactionResourceManager)trxResourceManager)) {
            return SQLProcessor.executeNativeSQLBal(env, client, paramSQLString);
        }
        BObject dbClient = (BObject)client.get(io.ballerina.stdlib.persist.sql.Constants.DB_CLIENT);
        Object sqlExecutionResult = ExecuteProcessor.nativeExecute((Environment)env, (BObject)dbClient, (BObject)paramSQLString, (AbstractStatementParameterProcessor)DefaultStatementParameterProcessor.getInstance());
        if (sqlExecutionResult instanceof BMap) {
            return ValueCreator.createRecordValue((Module)io.ballerina.stdlib.persist.sql.ModuleUtils.getModule(), (String)"ExecutionResult", (BMap)((BMap)sqlExecutionResult));
        }
        if (sqlExecutionResult instanceof BError) {
            return io.ballerina.stdlib.persist.sql.Utils.wrapSQLError((BError)sqlExecutionResult);
        }
        return null;
    }

    private static BStream queryNativeSQLBal(Environment env, BObject client, BObject paramSQLString, final BTypedesc targetType) {
        BObject dbClient = (BObject)client.get(io.ballerina.stdlib.persist.sql.Constants.DB_CLIENT);
        RecordType recordType = (RecordType)targetType.getDescribingType();
        StreamType streamType = TypeCreator.createStreamType((Type)recordType, (Type)PredefinedTypes.TYPE_NULL);
        final Future balFuture = env.markAsync();
        env.getRuntime().invokeMethodAsyncSequentially(dbClient, "query", null, env.getStrandMetadata(), new Callback(){

            public void notifySuccess(Object o) {
                BStream sqlStream = (BStream)o;
                BObject persistNativeStream = io.ballerina.stdlib.persist.sql.Utils.createPersistNativeSQLStream(sqlStream, null);
                RecordType streamConstraint = (RecordType)TypeUtils.getReferredType((Type)targetType.getDescribingType());
                balFuture.complete((Object)ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)persistNativeStream));
            }

            public void notifyFailure(BError bError) {
                BObject errorStream = io.ballerina.stdlib.persist.sql.Utils.createPersistNativeSQLStream(null, bError);
                balFuture.complete((Object)errorStream);
            }
        }, null, (Type)streamType, new Object[]{paramSQLString, true, targetType, true});
        return null;
    }

    private static Object executeNativeSQLBal(Environment env, BObject client, BObject paramSQLString) {
        BObject dbClient = (BObject)client.get(io.ballerina.stdlib.persist.sql.Constants.DB_CLIENT);
        RecordType persistExecutionResultType = TypeCreator.createRecordType((String)"ExecutionResult", (Module)io.ballerina.stdlib.persist.sql.ModuleUtils.getModule(), (long)0L, (boolean)true, (int)0);
        final Future balFuture = env.markAsync();
        env.getRuntime().invokeMethodAsyncSequentially(dbClient, "execute", null, env.getStrandMetadata(), new Callback(){

            public void notifySuccess(Object o) {
                if (o instanceof BMap) {
                    BMap persistExecutionResult = ValueCreator.createRecordValue((Module)io.ballerina.stdlib.persist.sql.ModuleUtils.getModule(), (String)"ExecutionResult", (BMap)((BMap)o));
                    balFuture.complete((Object)persistExecutionResult);
                } else if (o instanceof BError) {
                    BError persistError = io.ballerina.stdlib.persist.sql.Utils.wrapSQLError((BError)o);
                    balFuture.complete((Object)persistError);
                }
            }

            public void notifyFailure(BError bError) {
                BError persistError = ErrorGenerator.wrapError((BError)bError);
                balFuture.complete((Object)persistError);
            }
        }, null, (Type)persistExecutionResultType, new Object[]{paramSQLString, true});
        return null;
    }
}

