/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.core;

import io.camunda.search.clients.core.RequestBuilders;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.sort.SearchSortOptions;
import io.camunda.search.clients.sort.SortOptionsBuilders;
import io.camunda.search.clients.source.SearchSourceConfig;
import io.camunda.search.clients.source.SourceConfigBuilders;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public record SearchQueryRequest(List<String> index, SearchQuery query, List<SearchSortOptions> sort, Object[] searchAfter, Integer from, Integer size, SearchSourceConfig source) {
    public static SearchQueryRequest of(Function<Builder, ObjectBuilder<SearchQueryRequest>> fn) {
        return RequestBuilders.searchRequest(fn);
    }

    public static final class Builder
    implements ObjectBuilder<SearchQueryRequest> {
        private List<String> index;
        private SearchQuery query;
        private List<SearchSortOptions> sort;
        private Object[] searchAfter;
        private Integer from;
        private Integer size;
        private SearchSourceConfig source;

        public Builder index(List<String> values) {
            this.index = CollectionUtil.addValuesToList(this.index, values);
            return this;
        }

        public Builder index(String value, String ... values) {
            return this.index(CollectionUtil.collectValues(value, values));
        }

        public Builder query(SearchQuery value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<SearchQuery.Builder, ObjectBuilder<SearchQuery>> fn) {
            return this.query(SearchQueryBuilders.query(fn));
        }

        public Builder sort(List<SearchSortOptions> values) {
            this.sort = CollectionUtil.addValuesToList(this.sort, values);
            return this;
        }

        public Builder sort(SearchSortOptions value, SearchSortOptions ... values) {
            return this.sort(CollectionUtil.collectValues(value, values));
        }

        public Builder sort(Function<SearchSortOptions.Builder, ObjectBuilder<SearchSortOptions>> fn) {
            return this.sort(SortOptionsBuilders.sort(fn), new SearchSortOptions[0]);
        }

        public Builder searchAfter(Object[] value) {
            this.searchAfter = value;
            return this;
        }

        public Builder size(Integer value) {
            this.size = value;
            return this;
        }

        public Builder from(Integer value) {
            this.from = value;
            return this;
        }

        public Builder source(SearchSourceConfig value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<SearchSourceConfig.Builder, ObjectBuilder<SearchSourceConfig>> fn) {
            return this.source(SourceConfigBuilders.sourceConfig(fn));
        }

        @Override
        public SearchQueryRequest build() {
            return new SearchQueryRequest(Objects.requireNonNull(this.index, "Expected to create request for index, but given index was null."), this.query, this.sort, this.searchAfter, this.from, this.size, this.source);
        }
    }
}

