/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.sort;

import io.camunda.search.clients.sort.SortOptionsBuilders;
import io.camunda.search.clients.sort.SortOrder;
import io.camunda.util.ObjectBuilder;
import java.util.Objects;
import java.util.function.Function;

public record SearchFieldSort(String field, SortOrder order, String missing) {
    public boolean asc() {
        return SortOrder.ASC == this.order;
    }

    public boolean desc() {
        return SortOrder.DESC == this.order;
    }

    public static SearchFieldSort of(Function<Builder, ObjectBuilder<SearchFieldSort>> fn) {
        return SortOptionsBuilders.field(fn);
    }

    public static final class Builder
    implements ObjectBuilder<SearchFieldSort> {
        private String field;
        private SortOrder order;
        private String missing;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder asc() {
            return this.order(SortOrder.ASC);
        }

        public Builder desc() {
            return this.order(SortOrder.DESC);
        }

        public Builder order(SortOrder order) {
            this.order = order;
            return this;
        }

        public Builder missing(String value) {
            this.missing = value;
            return this;
        }

        @Override
        public SearchFieldSort build() {
            return new SearchFieldSort(Objects.requireNonNull(this.field, "Expected field name for field sorting, but got null."), this.order, this.missing);
        }
    }
}

