/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.CucumberException;
import cucumber.runtime.PickleStepDefinitionMatch;
import gherkin.pickles.PickleStep;
import java.util.List;

public class AmbiguousStepDefinitionsException
extends CucumberException {
    private final List<PickleStepDefinitionMatch> matches;

    public AmbiguousStepDefinitionsException(PickleStep step, List<PickleStepDefinitionMatch> matches) {
        super(AmbiguousStepDefinitionsException.createMessage(step, matches));
        this.matches = matches;
    }

    private static String createMessage(PickleStep step, List<PickleStepDefinitionMatch> matches) {
        StringBuilder msg = new StringBuilder();
        msg.append(AmbiguousStepDefinitionsException.quoteText(step.getText())).append(" matches more than one step definition:\n");
        for (PickleStepDefinitionMatch match : matches) {
            msg.append("  ").append(AmbiguousStepDefinitionsException.quoteText(match.getPattern())).append(" in ").append(match.getLocation()).append("\n");
        }
        return msg.toString();
    }

    private static String quoteText(String text) {
        return "\"" + text + "\"";
    }

    public List<PickleStepDefinitionMatch> getMatches() {
        return this.matches;
    }
}

