/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ExitStatus
implements EventListener {
    private static final byte ERRORS = 1;
    private final List<Result> results = new ArrayList<Result>();
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        @Override
        public void receive(TestCaseFinished event) {
            ExitStatus.this.results.add(event.result);
        }
    };

    ExitStatus() {
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    public byte exitStatus(boolean isStrict) {
        return this.results.isEmpty() || Collections.max(this.results, Result.SEVERITY).isOk(isStrict) ? (byte)0 : 1;
    }
}

