/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.snippets;

import cucumber.runtime.snippets.ArgumentPattern;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import gherkin.pickles.Argument;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import io.cucumber.cucumberexpressions.CucumberExpressionGenerator;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.datatable.DataTable;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SnippetGenerator {
    private static final ArgumentPattern[] DEFAULT_ARGUMENT_PATTERNS = new ArgumentPattern[]{new ArgumentPattern(Pattern.compile("\\{.*?}"))};
    private static final String REGEXP_HINT = "Write code here that turns the phrase above into concrete actions";
    private final Snippet snippet;
    private final CucumberExpressionGenerator generator;

    public SnippetGenerator(Snippet snippet, ParameterTypeRegistry parameterTypeRegistry) {
        this.snippet = snippet;
        this.generator = new CucumberExpressionGenerator(parameterTypeRegistry);
    }

    public String getSnippet(PickleStep step, String keyword, FunctionNameGenerator functionNameGenerator) {
        List expressions = this.generator.generateExpressions(step.getText());
        GeneratedExpression expression = (GeneratedExpression)expressions.get(0);
        return MessageFormat.format(this.snippet.template(), keyword, this.snippet.escapePattern(expression.getSource()), this.functionName(expression.getSource(), functionNameGenerator), this.snippet.arguments(this.arguments(step, expression.getParameterNames(), expression.getParameterTypes())), REGEXP_HINT, !step.getArgument().isEmpty() && step.getArgument().get(0) instanceof PickleTable ? this.snippet.tableHint() : "");
    }

    private String functionName(String sentence, FunctionNameGenerator functionNameGenerator) {
        if (functionNameGenerator == null) {
            return null;
        }
        for (ArgumentPattern argumentPattern : this.argumentPatterns()) {
            sentence = argumentPattern.replaceMatchesWithSpace(sentence);
        }
        return functionNameGenerator.generateFunctionName(sentence);
    }

    private Map<String, Type> arguments(PickleStep step, List<String> parameterNames, List<ParameterType<?>> parameterTypes) {
        LinkedHashMap<String, Type> arguments = new LinkedHashMap<String, Type>(parameterTypes.size() + 1);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            ParameterType<?> parameterType = parameterTypes.get(i);
            String parameterName = parameterNames.get(i);
            arguments.put(parameterName, parameterType.getType());
        }
        if (step.getArgument().isEmpty()) {
            return arguments;
        }
        Argument arg = (Argument)step.getArgument().get(0);
        if (arg instanceof PickleString) {
            arguments.put(this.parameterName("docString", parameterNames), (Type)((Object)String.class));
        }
        if (arg instanceof PickleTable) {
            arguments.put(this.parameterName("dataTable", parameterNames), (Type)((Object)DataTable.class));
        }
        return arguments;
    }

    private String parameterName(String name, List<String> parameterNames) {
        if (!parameterNames.contains(name)) {
            return name;
        }
        int i = 1;
        while (parameterNames.contains(name + i)) {
            ++i;
        }
        return name + i;
    }

    ArgumentPattern[] argumentPatterns() {
        return DEFAULT_ARGUMENT_PATTERNS;
    }
}

