/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.event.Event;
import cucumber.api.event.EventHandler;
import cucumber.runner.AbstractEventBus;
import cucumber.runner.EventBus;
import cucumber.runner.Runner;
import cucumber.runner.RunnerSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.RuntimeOptions;

public class ThreadLocalRunnerSupplier
implements RunnerSupplier {
    private final BackendSupplier backendSupplier;
    private final RuntimeOptions runtimeOptions;
    private final SynchronizedEventBus sharedEventBus;
    private final ThreadLocal<Runner> runners = new ThreadLocal<Runner>(){

        @Override
        protected Runner initialValue() {
            return ThreadLocalRunnerSupplier.this.createRunner();
        }
    };

    public ThreadLocalRunnerSupplier(RuntimeOptions runtimeOptions, EventBus sharedEventBus, BackendSupplier backendSupplier) {
        this.runtimeOptions = runtimeOptions;
        this.sharedEventBus = SynchronizedEventBus.synchronize(sharedEventBus);
        this.backendSupplier = backendSupplier;
    }

    @Override
    public Runner get() {
        return this.runners.get();
    }

    private Runner createRunner() {
        return new Runner(new LocalEventBus(this.sharedEventBus), this.backendSupplier.get(), this.runtimeOptions);
    }

    private static final class SynchronizedEventBus
    implements EventBus {
        private final EventBus delegate;

        static SynchronizedEventBus synchronize(EventBus eventBus) {
            if (eventBus instanceof SynchronizedEventBus) {
                return (SynchronizedEventBus)eventBus;
            }
            return new SynchronizedEventBus(eventBus);
        }

        private SynchronizedEventBus(EventBus delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized Long getTime() {
            return this.delegate.getTime();
        }

        @Override
        public synchronized void send(Event event) {
            this.delegate.send(event);
        }

        @Override
        public synchronized void sendAll(Iterable<Event> events) {
            this.delegate.sendAll(events);
        }

        @Override
        public synchronized <T extends Event> void registerHandlerFor(Class<T> eventType, EventHandler<T> handler) {
            this.delegate.registerHandlerFor(eventType, handler);
        }

        @Override
        public synchronized <T extends Event> void removeHandlerFor(Class<T> eventType, EventHandler<T> handler) {
            this.delegate.removeHandlerFor(eventType, handler);
        }
    }

    private static final class LocalEventBus
    extends AbstractEventBus {
        private final SynchronizedEventBus parent;

        LocalEventBus(SynchronizedEventBus parent) {
            this.parent = parent;
        }

        @Override
        public Long getTime() {
            return this.parent.getTime();
        }

        @Override
        public void send(Event event) {
            super.send(event);
            this.parent.send(event);
        }
    }
}

