/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import cucumber.api.SnippetType;
import cucumber.runtime.CucumberException;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import io.cucumber.core.model.FeaturePath;
import io.cucumber.core.model.FeatureWithLines;
import io.cucumber.core.model.GluePath;
import io.cucumber.core.model.RerunLoader;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import java.net.URI;
import java.util.regex.Pattern;

public final class CucumberOptionsAnnotationParser {
    private final RerunLoader rerunLoader;
    private boolean featuresSpecified = false;
    private boolean overridingGlueSpecified = false;
    private OptionsProvider optionsProvider;
    private CoreCucumberOptionsProvider coreCucumberOptionsProvider = new CoreCucumberOptionsProvider();

    public CucumberOptionsAnnotationParser() {
        this(new MultiLoader(CucumberOptionsAnnotationParser.class.getClassLoader()));
    }

    public CucumberOptionsAnnotationParser(ResourceLoader resourceLoader) {
        this.rerunLoader = new RerunLoader(resourceLoader);
    }

    public CucumberOptionsAnnotationParser withOptionsProvider(OptionsProvider optionsProvider) {
        this.optionsProvider = optionsProvider;
        return this;
    }

    public RuntimeOptionsBuilder parse(Class<?> clazz) {
        RuntimeOptionsBuilder args = new RuntimeOptionsBuilder();
        Class<?> classWithOptions = clazz;
        while (this.hasSuperClass(classWithOptions)) {
            CucumberOptions options = null;
            if (this.optionsProvider != null) {
                options = this.optionsProvider.getOptions(classWithOptions);
            }
            if (options == null) {
                options = this.coreCucumberOptionsProvider.getOptions(classWithOptions);
            }
            if (options != null) {
                this.addDryRun(options, args);
                this.addMonochrome(options, args);
                this.addTags(options, args);
                this.addPlugins(options, args);
                this.addStrict(options, args);
                this.addName(options, args);
                this.addSnippets(options, args);
                this.addGlue(options, args);
                this.addFeatures(options, args);
                this.addJunitOptions(options, args);
            }
            classWithOptions = classWithOptions.getSuperclass();
        }
        this.addDefaultFeaturePathIfNoFeaturePathIsSpecified(args, clazz);
        this.addDefaultGlueIfNoOverridingGlueIsSpecified(args, clazz);
        return args;
    }

    private void addName(CucumberOptions options, RuntimeOptionsBuilder args) {
        for (String name : options.name()) {
            Pattern pattern = Pattern.compile(name);
            args.addNameFilter(pattern);
        }
    }

    private void addSnippets(CucumberOptions options, RuntimeOptionsBuilder args) {
        args.setSnippetType(options.snippets());
    }

    private void addDryRun(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options.dryRun()) {
            args.setDryRun(true);
        }
    }

    private void addMonochrome(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options.monochrome() || this.runningInEnvironmentWithoutAnsiSupport()) {
            args.setMonochrome(true);
        }
    }

    private void addTags(CucumberOptions options, RuntimeOptionsBuilder args) {
        for (String tags : options.tags()) {
            args.addTagFilter(tags);
        }
    }

    private void addPlugins(CucumberOptions options, RuntimeOptionsBuilder args) {
        for (String plugin : options.plugin()) {
            args.addPluginName(plugin, false);
        }
    }

    private void addFeatures(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options != null && options.features().length != 0) {
            for (String feature : options.features()) {
                if (feature.startsWith("@")) {
                    args.setIsRerun(true);
                    URI rerunFile = FeaturePath.parse(feature.substring(1));
                    for (FeatureWithLines featureWithLines : this.rerunLoader.load(rerunFile)) {
                        args.addFeature(featureWithLines);
                    }
                    continue;
                }
                FeatureWithLines featureWithLines = FeatureWithLines.parse(feature);
                args.addFeature(featureWithLines);
            }
            this.featuresSpecified = true;
        }
    }

    private void addDefaultFeaturePathIfNoFeaturePathIsSpecified(RuntimeOptionsBuilder args, Class clazz) {
        if (!this.featuresSpecified) {
            String packageName = CucumberOptionsAnnotationParser.packagePath(clazz);
            FeatureWithLines featureWithLines = FeatureWithLines.parse(packageName);
            args.addFeature(featureWithLines);
        }
    }

    private void addGlue(CucumberOptions options, RuntimeOptionsBuilder args) {
        boolean hasGlue;
        boolean hasExtraGlue = options.extraGlue().length > 0;
        boolean bl = hasGlue = options.glue().length > 0;
        if (hasExtraGlue && hasGlue) {
            throw new CucumberException("glue and extraGlue cannot be specified at the same time");
        }
        String[] gluePaths = new String[]{};
        if (hasExtraGlue) {
            gluePaths = options.extraGlue();
        }
        if (hasGlue) {
            gluePaths = options.glue();
            this.overridingGlueSpecified = true;
        }
        for (String glue : gluePaths) {
            args.addGlue(GluePath.parse(glue));
        }
    }

    private void addDefaultGlueIfNoOverridingGlueIsSpecified(RuntimeOptionsBuilder args, Class clazz) {
        if (!this.overridingGlueSpecified) {
            args.addGlue(GluePath.parse(CucumberOptionsAnnotationParser.packageName(clazz)));
        }
    }

    private void addStrict(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options.strict()) {
            args.setStrict(true);
        }
    }

    private void addJunitOptions(CucumberOptions options, RuntimeOptionsBuilder args) {
        for (String junitOption : options.junit()) {
            args.addJunitOption(junitOption);
        }
    }

    private static String packagePath(Class clazz) {
        String packageName = CucumberOptionsAnnotationParser.packageName(clazz);
        if (packageName.isEmpty()) {
            return "classpath:/";
        }
        return "classpath:" + packageName.replace('.', '/');
    }

    static String packageName(Class clazz) {
        String className = clazz.getName();
        return className.substring(0, Math.max(0, className.lastIndexOf(46)));
    }

    private boolean runningInEnvironmentWithoutAnsiSupport() {
        boolean intelliJidea = System.getProperty("idea.launcher.bin.path") != null;
        return intelliJidea;
    }

    private boolean hasSuperClass(Class classWithOptions) {
        return classWithOptions != Object.class;
    }

    private static class CoreCucumberOptionsProvider
    implements OptionsProvider {
        private CoreCucumberOptionsProvider() {
        }

        @Override
        public CucumberOptions getOptions(Class<?> clazz) {
            cucumber.api.CucumberOptions annotation = clazz.getAnnotation(cucumber.api.CucumberOptions.class);
            if (annotation == null) {
                return null;
            }
            return new CoreCucumberOptions(annotation);
        }
    }

    private static class CoreCucumberOptions
    implements CucumberOptions {
        private final cucumber.api.CucumberOptions annotation;

        CoreCucumberOptions(cucumber.api.CucumberOptions annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean dryRun() {
            return this.annotation.dryRun();
        }

        @Override
        public boolean strict() {
            return this.annotation.strict();
        }

        @Override
        public String[] features() {
            return this.annotation.features();
        }

        @Override
        public String[] glue() {
            return this.annotation.glue();
        }

        @Override
        public String[] extraGlue() {
            return this.annotation.extraGlue();
        }

        @Override
        public String[] tags() {
            return this.annotation.tags();
        }

        @Override
        public String[] plugin() {
            return this.annotation.plugin();
        }

        @Override
        public boolean monochrome() {
            return this.annotation.monochrome();
        }

        @Override
        public String[] name() {
            return this.annotation.name();
        }

        @Override
        public SnippetType snippets() {
            return this.annotation.snippets();
        }

        @Override
        public String[] junit() {
            return this.annotation.junit();
        }
    }

    public static interface CucumberOptions {
        public boolean dryRun();

        public boolean strict();

        public String[] features();

        public String[] glue();

        public String[] extraGlue();

        public String[] tags();

        public String[] plugin();

        public boolean monochrome();

        public String[] name();

        public SnippetType snippets();

        public String[] junit();
    }

    public static interface OptionsProvider {
        public CucumberOptions getOptions(Class<?> var1);
    }
}

