/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.Stats;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.StrictAware;
import io.cucumber.plugin.SummaryPrinter;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.TestRunFinished;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class DefaultSummaryPrinter
implements SummaryPrinter,
ColorAware,
StrictAware,
ConcurrentEventListener {
    private final Set<String> snippets = new LinkedHashSet<String>();
    private final Stats stats = new Stats();
    private final PrintStream out;

    public DefaultSummaryPrinter() {
        this(System.out);
    }

    DefaultSummaryPrinter(OutputStream out) {
        this.out = new PrintStream(out);
    }

    private void handleSnippetsSuggestedEvent(SnippetsSuggestedEvent event) {
        this.snippets.addAll(event.getSnippets());
    }

    private void print() {
        this.out.println();
        this.printStats();
        this.printErrors();
        this.printSnippets();
        this.out.println();
    }

    private void printStats() {
        this.stats.printStats(this.out);
        this.out.println();
    }

    private void printErrors() {
        List<Throwable> errors = this.stats.getErrors();
        if (errors.isEmpty()) {
            return;
        }
        this.out.println();
        for (Throwable error : errors) {
            error.printStackTrace(this.out);
            this.out.println();
        }
    }

    private void printSnippets() {
        if (this.snippets.isEmpty()) {
            return;
        }
        this.out.println();
        this.out.println("You can implement missing steps with the snippets below:");
        this.out.println();
        for (String snippet : this.snippets) {
            this.out.println(snippet);
            this.out.println();
        }
    }

    public void setEventPublisher(EventPublisher publisher) {
        this.stats.setEventPublisher(publisher);
        publisher.registerHandlerFor(SnippetsSuggestedEvent.class, this::handleSnippetsSuggestedEvent);
        publisher.registerHandlerFor(TestRunFinished.class, event -> this.print());
    }

    public void setMonochrome(boolean monochrome) {
        this.stats.setMonochrome(monochrome);
    }

    public void setStrict(boolean strict) {
        this.stats.setStrict(strict);
    }
}

