/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;

public final class TestCaseResultObserver
implements AutoCloseable {
    private final EventPublisher bus;
    private final Map<StepLocation, List<String>> snippetsPerStep = new TreeMap<StepLocation, List<String>>();
    private final List<Suggestion> suggestions = new ArrayList<Suggestion>();
    private final EventHandler<SnippetsSuggestedEvent> snippetsSuggested = this::handleSnippetSuggestedEvent;
    private final EventHandler<TestStepFinished> testStepFinished = this::handleTestStepFinished;
    private Result result;
    private final EventHandler<TestCaseFinished> testCaseFinished = this::handleTestCaseFinished;

    public TestCaseResultObserver(EventPublisher bus) {
        this.bus = bus;
        bus.registerHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggested);
        bus.registerHandlerFor(TestStepFinished.class, this.testStepFinished);
        bus.registerHandlerFor(TestCaseFinished.class, this.testCaseFinished);
    }

    @Override
    public void close() {
        this.bus.removeHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggested);
        this.bus.removeHandlerFor(TestStepFinished.class, this.testStepFinished);
        this.bus.removeHandlerFor(TestCaseFinished.class, this.testCaseFinished);
    }

    private void handleSnippetSuggestedEvent(SnippetsSuggestedEvent event) {
        this.snippetsPerStep.putIfAbsent(new StepLocation(event.getUri(), event.getStepLine()), event.getSnippets());
    }

    private void handleTestStepFinished(TestStepFinished event) {
        Result result = event.getResult();
        Status status = result.getStatus();
        if (!status.is(Status.UNDEFINED)) {
            return;
        }
        TestStep testStep = event.getTestStep();
        if (!(testStep instanceof PickleStepTestStep)) {
            return;
        }
        PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
        String stepText = pickleStepTestStep.getStepText();
        List<String> snippets = this.snippetsPerStep.get(new StepLocation(pickleStepTestStep.getUri(), pickleStepTestStep.getStepLine()));
        this.suggestions.add(new Suggestion(stepText, snippets));
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        this.result = event.getResult();
    }

    public void assertTestCasePassed(Supplier<Throwable> testCaseSkipped, Function<Throwable, Throwable> testCaseSkippedWithException, Function<List<Suggestion>, Throwable> testCaseWasUndefined, Function<Throwable, Throwable> testCaseWasPending) {
        Status status = this.result.getStatus();
        if (status.is(Status.PASSED)) {
            return;
        }
        Throwable error = this.result.getError();
        if (status.is(Status.SKIPPED) && error == null) {
            Throwable throwable = testCaseSkipped.get();
            throw new TestCaseFailed(throwable);
        }
        if (status.is(Status.SKIPPED) && error != null) {
            Throwable throwable = testCaseSkippedWithException.apply(error);
            throw new TestCaseFailed(throwable);
        }
        if (status.is(Status.UNDEFINED)) {
            Throwable throwable = testCaseWasUndefined.apply(this.suggestions);
            throw new TestCaseFailed(throwable);
        }
        if (status.is(Status.PENDING)) {
            Throwable throwable = testCaseWasPending.apply(error);
            throw new TestCaseFailed(throwable);
        }
        Objects.requireNonNull(error, "result.error=null while result.status=" + this.result.getStatus());
        throw new TestCaseFailed(error);
    }

    public static final class Suggestion {
        final String step;
        final List<String> snippets;

        public Suggestion(String step, List<String> snippets) {
            this.step = step;
            this.snippets = snippets;
        }

        public String getStep() {
            return this.step;
        }

        public List<String> getSnippets() {
            return this.snippets;
        }
    }

    private static final class StepLocation
    implements Comparable<StepLocation> {
        private final URI uri;
        private final int line;

        private StepLocation(URI uri, int line) {
            this.uri = uri;
            this.line = line;
        }

        @Override
        public int compareTo(StepLocation o) {
            int order = this.uri.compareTo(o.uri);
            return order != 0 ? order : Integer.compare(this.line, o.line);
        }
    }

    static class TestCaseFailed
    extends RuntimeException {
        public TestCaseFailed(Throwable throwable) {
            super(throwable);
        }
    }
}

