package io.dekorate.knative.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AutoScalingFluent<A extends AutoScalingFluent<A>> extends BaseFluent<A>{
  public AutoScalingFluent() {
  }
  
  public AutoScalingFluent(AutoScaling instance) {
    this.copyInstance(instance);
  }
  private AutoScalerClass autoScalerClass;
  private AutoscalingMetric metric;
  private Integer target;
  private Integer containerConcurrency;
  private Integer targetUtilizationPercentage;
  
  protected void copyInstance(AutoScaling instance) {
    instance = (instance != null ? instance : new AutoScaling());
    if (instance != null) {
          this.withAutoScalerClass(instance.getAutoScalerClass());
          this.withMetric(instance.getMetric());
          this.withTarget(instance.getTarget());
          this.withContainerConcurrency(instance.getContainerConcurrency());
          this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage());
        }
  }
  
  public AutoScalerClass getAutoScalerClass() {
    return this.autoScalerClass;
  }
  
  public A withAutoScalerClass(AutoScalerClass autoScalerClass) {
    this.autoScalerClass = autoScalerClass;
    return (A) this;
  }
  
  public boolean hasAutoScalerClass() {
    return this.autoScalerClass != null;
  }
  
  public AutoscalingMetric getMetric() {
    return this.metric;
  }
  
  public A withMetric(AutoscalingMetric metric) {
    this.metric = metric;
    return (A) this;
  }
  
  public boolean hasMetric() {
    return this.metric != null;
  }
  
  public Integer getTarget() {
    return this.target;
  }
  
  public A withTarget(Integer target) {
    this.target = target;
    return (A) this;
  }
  
  public boolean hasTarget() {
    return this.target != null;
  }
  
  public Integer getContainerConcurrency() {
    return this.containerConcurrency;
  }
  
  public A withContainerConcurrency(Integer containerConcurrency) {
    this.containerConcurrency = containerConcurrency;
    return (A) this;
  }
  
  public boolean hasContainerConcurrency() {
    return this.containerConcurrency != null;
  }
  
  public Integer getTargetUtilizationPercentage() {
    return this.targetUtilizationPercentage;
  }
  
  public A withTargetUtilizationPercentage(Integer targetUtilizationPercentage) {
    this.targetUtilizationPercentage = targetUtilizationPercentage;
    return (A) this;
  }
  
  public boolean hasTargetUtilizationPercentage() {
    return this.targetUtilizationPercentage != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AutoScalingFluent that = (AutoScalingFluent) o;
    if (!java.util.Objects.equals(autoScalerClass, that.autoScalerClass)) return false;
    if (!java.util.Objects.equals(metric, that.metric)) return false;
    if (!java.util.Objects.equals(target, that.target)) return false;
    if (!java.util.Objects.equals(containerConcurrency, that.containerConcurrency)) return false;
    if (!java.util.Objects.equals(targetUtilizationPercentage, that.targetUtilizationPercentage)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(autoScalerClass,  metric,  target,  containerConcurrency,  targetUtilizationPercentage,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (autoScalerClass != null) { sb.append("autoScalerClass:"); sb.append(autoScalerClass + ","); }
    if (metric != null) { sb.append("metric:"); sb.append(metric + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (containerConcurrency != null) { sb.append("containerConcurrency:"); sb.append(containerConcurrency + ","); }
    if (targetUtilizationPercentage != null) { sb.append("targetUtilizationPercentage:"); sb.append(targetUtilizationPercentage); }
    sb.append("}");
    return sb.toString();
  }
  

}