package io.dekorate.knative.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KnativeConfigFluent<A extends KnativeConfigFluent<A>> extends BaseConfigFluent<A>{
  public KnativeConfigFluent() {
  }
  
  public KnativeConfigFluent(KnativeConfig instance) {
    this.copyInstance(instance);
  }
  private String revisionName;
  private String host;
  private HttpTransportVersion httpTransportVersion;
  private Boolean expose;
  private Integer minScale;
  private Integer maxScale;
  private Boolean scaleToZeroEnabled;
  private AutoScalingBuilder revisionAutoScaling;
  private GlobalAutoScalingBuilder globalAutoScaling;
  private String templateName;
  private ArrayList<TrafficBuilder> traffic = new ArrayList<TrafficBuilder>();
  
  protected void copyInstance(KnativeConfig instance) {
    instance = (instance != null ? instance : new KnativeConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withPartOf(instance.getPartOf());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withDeploymentKind(instance.getDeploymentKind());
          this.withLabels(instance.getLabels());
          this.withAnnotations(instance.getAnnotations());
          this.withEnvVars(instance.getEnvVars());
          this.withWorkingDir(instance.getWorkingDir());
          this.withCommand(instance.getCommand());
          this.withArguments(instance.getArguments());
          this.withServiceAccount(instance.getServiceAccount());
          this.withPorts(instance.getPorts());
          this.withServiceType(instance.getServiceType());
          this.withPvcVolumes(instance.getPvcVolumes());
          this.withSecretVolumes(instance.getSecretVolumes());
          this.withConfigMapVolumes(instance.getConfigMapVolumes());
          this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
          this.withGitRepoVolumes(instance.getGitRepoVolumes());
          this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
          this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
          this.withAzureFileVolumes(instance.getAzureFileVolumes());
          this.withMounts(instance.getMounts());
          this.withImagePullPolicy(instance.getImagePullPolicy());
          this.withImagePullSecrets(instance.getImagePullSecrets());
          this.withDeploymentStrategy(instance.getDeploymentStrategy());
          this.withRollingUpdate(instance.getRollingUpdate());
          this.withHostAliases(instance.getHostAliases());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withStartupProbe(instance.getStartupProbe());
          this.withRequestResources(instance.getRequestResources());
          this.withLimitResources(instance.getLimitResources());
          this.withSidecars(instance.getSidecars());
          this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
          this.withJobs(instance.getJobs());
          this.withCronJobs(instance.getCronJobs());
          this.withRevisionName(instance.getRevisionName());
          this.withHost(instance.getHost());
          this.withHttpTransportVersion(instance.getHttpTransportVersion());
          this.withExpose(instance.getExpose());
          this.withMinScale(instance.getMinScale());
          this.withMaxScale(instance.getMaxScale());
          this.withScaleToZeroEnabled(instance.getScaleToZeroEnabled());
          this.withRevisionAutoScaling(instance.getRevisionAutoScaling());
          this.withGlobalAutoScaling(instance.getGlobalAutoScaling());
          this.withTemplateName(instance.getTemplateName());
          this.withTraffic(instance.getTraffic());
        }
  }
  
  public String getRevisionName() {
    return this.revisionName;
  }
  
  public A withRevisionName(String revisionName) {
    this.revisionName = revisionName;
    return (A) this;
  }
  
  public boolean hasRevisionName() {
    return this.revisionName != null;
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host = host;
    return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public HttpTransportVersion getHttpTransportVersion() {
    return this.httpTransportVersion;
  }
  
  public A withHttpTransportVersion(HttpTransportVersion httpTransportVersion) {
    this.httpTransportVersion = httpTransportVersion;
    return (A) this;
  }
  
  public boolean hasHttpTransportVersion() {
    return this.httpTransportVersion != null;
  }
  
  public Boolean getExpose() {
    return this.expose;
  }
  
  public A withExpose(Boolean expose) {
    this.expose = expose;
    return (A) this;
  }
  
  public boolean hasExpose() {
    return this.expose != null;
  }
  
  public Integer getMinScale() {
    return this.minScale;
  }
  
  public A withMinScale(Integer minScale) {
    this.minScale = minScale;
    return (A) this;
  }
  
  public boolean hasMinScale() {
    return this.minScale != null;
  }
  
  public Integer getMaxScale() {
    return this.maxScale;
  }
  
  public A withMaxScale(Integer maxScale) {
    this.maxScale = maxScale;
    return (A) this;
  }
  
  public boolean hasMaxScale() {
    return this.maxScale != null;
  }
  
  public Boolean getScaleToZeroEnabled() {
    return this.scaleToZeroEnabled;
  }
  
  public A withScaleToZeroEnabled(Boolean scaleToZeroEnabled) {
    this.scaleToZeroEnabled = scaleToZeroEnabled;
    return (A) this;
  }
  
  public boolean hasScaleToZeroEnabled() {
    return this.scaleToZeroEnabled != null;
  }
  
  public AutoScaling buildRevisionAutoScaling() {
    return this.revisionAutoScaling != null ? this.revisionAutoScaling.build() : null;
  }
  
  public A withRevisionAutoScaling(AutoScaling revisionAutoScaling) {
    this._visitables.remove("revisionAutoScaling");
    if (revisionAutoScaling != null) {
        this.revisionAutoScaling = new AutoScalingBuilder(revisionAutoScaling);
        this._visitables.get("revisionAutoScaling").add(this.revisionAutoScaling);
    } else {
        this.revisionAutoScaling = null;
        this._visitables.get("revisionAutoScaling").remove(this.revisionAutoScaling);
    }
    return (A) this;
  }
  
  public boolean hasRevisionAutoScaling() {
    return this.revisionAutoScaling != null;
  }
  
  public RevisionAutoScalingNested<A> withNewRevisionAutoScaling() {
    return new RevisionAutoScalingNested(null);
  }
  
  public RevisionAutoScalingNested<A> withNewRevisionAutoScalingLike(AutoScaling item) {
    return new RevisionAutoScalingNested(item);
  }
  
  public RevisionAutoScalingNested<A> editRevisionAutoScaling() {
    return withNewRevisionAutoScalingLike(java.util.Optional.ofNullable(buildRevisionAutoScaling()).orElse(null));
  }
  
  public RevisionAutoScalingNested<A> editOrNewRevisionAutoScaling() {
    return withNewRevisionAutoScalingLike(java.util.Optional.ofNullable(buildRevisionAutoScaling()).orElse(new AutoScalingBuilder().build()));
  }
  
  public RevisionAutoScalingNested<A> editOrNewRevisionAutoScalingLike(AutoScaling item) {
    return withNewRevisionAutoScalingLike(java.util.Optional.ofNullable(buildRevisionAutoScaling()).orElse(item));
  }
  
  public GlobalAutoScaling buildGlobalAutoScaling() {
    return this.globalAutoScaling != null ? this.globalAutoScaling.build() : null;
  }
  
  public A withGlobalAutoScaling(GlobalAutoScaling globalAutoScaling) {
    this._visitables.remove("globalAutoScaling");
    if (globalAutoScaling != null) {
        this.globalAutoScaling = new GlobalAutoScalingBuilder(globalAutoScaling);
        this._visitables.get("globalAutoScaling").add(this.globalAutoScaling);
    } else {
        this.globalAutoScaling = null;
        this._visitables.get("globalAutoScaling").remove(this.globalAutoScaling);
    }
    return (A) this;
  }
  
  public boolean hasGlobalAutoScaling() {
    return this.globalAutoScaling != null;
  }
  
  public GlobalAutoScalingNested<A> withNewGlobalAutoScaling() {
    return new GlobalAutoScalingNested(null);
  }
  
  public GlobalAutoScalingNested<A> withNewGlobalAutoScalingLike(GlobalAutoScaling item) {
    return new GlobalAutoScalingNested(item);
  }
  
  public GlobalAutoScalingNested<A> editGlobalAutoScaling() {
    return withNewGlobalAutoScalingLike(java.util.Optional.ofNullable(buildGlobalAutoScaling()).orElse(null));
  }
  
  public GlobalAutoScalingNested<A> editOrNewGlobalAutoScaling() {
    return withNewGlobalAutoScalingLike(java.util.Optional.ofNullable(buildGlobalAutoScaling()).orElse(new GlobalAutoScalingBuilder().build()));
  }
  
  public GlobalAutoScalingNested<A> editOrNewGlobalAutoScalingLike(GlobalAutoScaling item) {
    return withNewGlobalAutoScalingLike(java.util.Optional.ofNullable(buildGlobalAutoScaling()).orElse(item));
  }
  
  public String getTemplateName() {
    return this.templateName;
  }
  
  public A withTemplateName(String templateName) {
    this.templateName = templateName;
    return (A) this;
  }
  
  public boolean hasTemplateName() {
    return this.templateName != null;
  }
  
  public A withTraffic(io.dekorate.knative.config.Traffic... traffic) {
    if (this.traffic != null) {
        this.traffic.clear();
        _visitables.remove("traffic");
    }
    if (traffic != null) {
      for (Traffic item : traffic) {
        this.addToTraffic(item);
      }
    }
    return (A) this;
  }
  
  public Traffic[] buildTraffic() {
    int size = traffic != null ? traffic.size() : 0;;
    Traffic[] result = new Traffic[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Traffic,TrafficBuilder> item : traffic) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Traffic buildTraffic(int index) {
    return this.traffic.get(index).build();
  }
  
  public Traffic buildFirstTraffic() {
    return this.traffic.get(0).build();
  }
  
  public Traffic buildLastTraffic() {
    return this.traffic.get(traffic.size() - 1).build();
  }
  
  public Traffic buildMatchingTraffic(Predicate<TrafficBuilder> predicate) {
      for (TrafficBuilder item : traffic) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTraffic(Predicate<TrafficBuilder> predicate) {
      for (TrafficBuilder item : traffic) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToTraffic(int index,Traffic item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
    TrafficBuilder builder = new TrafficBuilder(item);
    if (index < 0 || index >= traffic.size()) { _visitables.get("traffic").add(builder); traffic.add(builder); } else { _visitables.get("traffic").add(index, builder); traffic.add(index, builder);}
    return (A)this;
  }
  
  public A setToTraffic(int index,Traffic item) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
    TrafficBuilder builder = new TrafficBuilder(item);
    if (index < 0 || index >= traffic.size()) { _visitables.get("traffic").add(builder); traffic.add(builder); } else { _visitables.get("traffic").set(index, builder); traffic.set(index, builder);}
    return (A)this;
  }
  
  public A addToTraffic(io.dekorate.knative.config.Traffic... items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
    for (Traffic item : items) {TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  
  public A addAllToTraffic(Collection<Traffic> items) {
    if (this.traffic == null) {this.traffic = new ArrayList<TrafficBuilder>();}
    for (Traffic item : items) {TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
  }
  
  public A removeFromTraffic(io.dekorate.knative.config.Traffic... items) {
    if (this.traffic == null) return (A)this;
    for (Traffic item : items) {TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").remove(builder); this.traffic.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTraffic(Collection<Traffic> items) {
    if (this.traffic == null) return (A)this;
    for (Traffic item : items) {TrafficBuilder builder = new TrafficBuilder(item);_visitables.get("traffic").remove(builder); this.traffic.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTraffic(Predicate<TrafficBuilder> predicate) {
    if (traffic == null) return (A) this;
    final Iterator<TrafficBuilder> each = traffic.iterator();
    final List visitables = _visitables.get("traffic");
    while (each.hasNext()) {
      TrafficBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasTraffic() {
    return this.traffic != null && !this.traffic.isEmpty();
  }
  
  public A addNewTraffic(String tag,String revisionName,Boolean latestRevision,Integer percentage) {
    return (A)addToTraffic(new Traffic(tag, revisionName, latestRevision, percentage));
  }
  
  public TrafficNested<A> addNewTraffic() {
    return new TrafficNested(-1, null);
  }
  
  public TrafficNested<A> addNewTrafficLike(Traffic item) {
    return new TrafficNested(-1, item);
  }
  
  public TrafficNested<A> setNewTrafficLike(int index,Traffic item) {
    return new TrafficNested(index, item);
  }
  
  public TrafficNested<A> editTraffic(int index) {
    if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  
  public TrafficNested<A> editFirstTraffic() {
    if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
    return setNewTrafficLike(0, buildTraffic(0));
  }
  
  public TrafficNested<A> editLastTraffic() {
    int index = traffic.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  
  public TrafficNested<A> editMatchingTraffic(Predicate<TrafficBuilder> predicate) {
    int index = -1;
    for (int i=0;i<traffic.size();i++) { 
    if (predicate.test(traffic.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
    return setNewTrafficLike(index, buildTraffic(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KnativeConfigFluent that = (KnativeConfigFluent) o;
    if (!java.util.Objects.equals(revisionName, that.revisionName)) return false;
    if (!java.util.Objects.equals(host, that.host)) return false;
    if (!java.util.Objects.equals(httpTransportVersion, that.httpTransportVersion)) return false;
    if (!java.util.Objects.equals(expose, that.expose)) return false;
    if (!java.util.Objects.equals(minScale, that.minScale)) return false;
    if (!java.util.Objects.equals(maxScale, that.maxScale)) return false;
    if (!java.util.Objects.equals(scaleToZeroEnabled, that.scaleToZeroEnabled)) return false;
    if (!java.util.Objects.equals(revisionAutoScaling, that.revisionAutoScaling)) return false;
    if (!java.util.Objects.equals(globalAutoScaling, that.globalAutoScaling)) return false;
    if (!java.util.Objects.equals(templateName, that.templateName)) return false;
    if (!java.util.Objects.equals(traffic, that.traffic)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(revisionName,  host,  httpTransportVersion,  expose,  minScale,  maxScale,  scaleToZeroEnabled,  revisionAutoScaling,  globalAutoScaling,  templateName,  traffic,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (revisionName != null) { sb.append("revisionName:"); sb.append(revisionName + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (httpTransportVersion != null) { sb.append("httpTransportVersion:"); sb.append(httpTransportVersion + ","); }
    if (expose != null) { sb.append("expose:"); sb.append(expose + ","); }
    if (minScale != null) { sb.append("minScale:"); sb.append(minScale + ","); }
    if (maxScale != null) { sb.append("maxScale:"); sb.append(maxScale + ","); }
    if (scaleToZeroEnabled != null) { sb.append("scaleToZeroEnabled:"); sb.append(scaleToZeroEnabled + ","); }
    if (revisionAutoScaling != null) { sb.append("revisionAutoScaling:"); sb.append(revisionAutoScaling + ","); }
    if (globalAutoScaling != null) { sb.append("globalAutoScaling:"); sb.append(globalAutoScaling + ","); }
    if (templateName != null) { sb.append("templateName:"); sb.append(templateName + ","); }
    if (traffic != null && !traffic.isEmpty()) { sb.append("traffic:"); sb.append(traffic); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withExpose() {
    return withExpose(true);
  }
  
  public A withScaleToZeroEnabled() {
    return withScaleToZeroEnabled(true);
  }
  public class RevisionAutoScalingNested<N> extends AutoScalingFluent<RevisionAutoScalingNested<N>> implements Nested<N>{
    RevisionAutoScalingNested(AutoScaling item) {
      this.builder = new AutoScalingBuilder(this, item);
    }
    AutoScalingBuilder builder;
    
    public N and() {
      return (N) KnativeConfigFluent.this.withRevisionAutoScaling(builder.build());
    }
    
    public N endRevisionAutoScaling() {
      return and();
    }
    
  
  }
  public class GlobalAutoScalingNested<N> extends GlobalAutoScalingFluent<GlobalAutoScalingNested<N>> implements Nested<N>{
    GlobalAutoScalingNested(GlobalAutoScaling item) {
      this.builder = new GlobalAutoScalingBuilder(this, item);
    }
    GlobalAutoScalingBuilder builder;
    
    public N and() {
      return (N) KnativeConfigFluent.this.withGlobalAutoScaling(builder.build());
    }
    
    public N endGlobalAutoScaling() {
      return and();
    }
    
  
  }
  public class TrafficNested<N> extends TrafficFluent<TrafficNested<N>> implements Nested<N>{
    TrafficNested(int index,Traffic item) {
      this.index = index;
      this.builder = new TrafficBuilder(this, item);
    }
    TrafficBuilder builder;
    int index;
    
    public N and() {
      return (N) KnativeConfigFluent.this.setToTraffic(index,builder.build());
    }
    
    public N endTraffic() {
      return and();
    }
    
  
  }

}