/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.digdag.client.DigdagVersion;
import io.digdag.client.config.ConfigException;
import io.digdag.core.crypto.SecretCrypto;
import io.digdag.core.crypto.SecretCryptoProvider;
import io.digdag.core.database.DatabaseSecretControlStoreManager;
import io.digdag.core.database.DatabaseSecretStoreManager;
import io.digdag.core.repository.ModelValidationException;
import io.digdag.core.repository.ResourceConflictException;
import io.digdag.core.repository.ResourceLimitExceededException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.guice.rs.GuiceRsModule;
import io.digdag.server.AuthRequestFilter;
import io.digdag.server.AuthenticatorProvider;
import io.digdag.server.GenericJsonExceptionHandler;
import io.digdag.server.ServerConfig;
import io.digdag.server.ac.DefaultAccessController;
import io.digdag.server.auth.BasicAuthenticatorFactory;
import io.digdag.server.rs.AdminResource;
import io.digdag.server.rs.AdminRestricted;
import io.digdag.server.rs.AttemptResource;
import io.digdag.server.rs.LogResource;
import io.digdag.server.rs.ProjectResource;
import io.digdag.server.rs.ScheduleResource;
import io.digdag.server.rs.SessionResource;
import io.digdag.server.rs.UiResource;
import io.digdag.server.rs.VersionResource;
import io.digdag.server.rs.WorkflowResource;
import io.digdag.spi.AuthenticatedUser;
import io.digdag.spi.Authenticator;
import io.digdag.spi.AuthenticatorFactory;
import io.digdag.spi.SecretControlStoreManager;
import io.digdag.spi.SecretStoreManager;
import io.digdag.spi.StorageFileNotFoundException;
import io.digdag.spi.ac.AccessControlException;
import io.digdag.spi.ac.AccessController;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerModule
extends GuiceRsModule {
    private static final Logger logger = LoggerFactory.getLogger(ServerModule.class);
    private ServerConfig serverConfig;

    public ServerModule(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void configure() {
        GuiceRsModule.ApplicationBindingBuilder builder = ((GuiceRsModule.ApplicationBindingBuilder)this.bindApplication().matches(new String[]{"/api/*"})).addProvider(JacksonJsonProvider.class, JsonProviderProvider.class).addProvider(AuthRequestFilter.class).addProvider(CustomHeaderFilter.class).addProvider(AdminRestrictedFilter.class);
        this.bindResources(builder);
        this.bindAuthorization();
        this.bindAuthenticator();
        this.bindExceptionhandlers(builder);
        this.bindSecrets();
        this.bindUiApplication();
        if (this.serverConfig.getEnableSwagger()) {
            this.enableSwagger(builder);
        }
    }

    protected void bindSecrets() {
        this.binder().bind(SecretCrypto.class).toProvider(SecretCryptoProvider.class).in(Scopes.SINGLETON);
        this.binder().bind(SecretStoreManager.class).to(DatabaseSecretStoreManager.class).in(Scopes.SINGLETON);
        this.binder().bind(SecretControlStoreManager.class).to(DatabaseSecretControlStoreManager.class);
    }

    protected void bindResources(GuiceRsModule.ApplicationBindingBuilder builder) {
        builder.addResources(new Class[]{ProjectResource.class, WorkflowResource.class, ScheduleResource.class, SessionResource.class, AttemptResource.class, LogResource.class, VersionResource.class, AdminResource.class});
    }

    protected void bindAuthenticator() {
        Multibinder.newSetBinder((Binder)this.binder(), AuthenticatorFactory.class).addBinding().to(BasicAuthenticatorFactory.class).in(Scopes.SINGLETON);
        this.binder().bind(Authenticator.class).toProvider(AuthenticatorProvider.class).in(Scopes.SINGLETON);
    }

    protected void bindAuthorization() {
        this.binder().bind(AccessController.class).to(DefaultAccessController.class);
    }

    protected void bindExceptionhandlers(GuiceRsModule.ApplicationBindingBuilder builder) {
        builder.addProviderInstance((Object)new GenericJsonExceptionHandler<AccessControlException>(Response.Status.FORBIDDEN){}).addProviderInstance((Object)new GenericJsonExceptionHandler<ResourceNotFoundException>(Response.Status.NOT_FOUND){}).addProviderInstance((Object)new GenericJsonExceptionHandler<StorageFileNotFoundException>(Response.Status.NOT_FOUND){}).addProviderInstance((Object)new GenericJsonExceptionHandler<ResourceConflictException>(Response.Status.CONFLICT){}).addProviderInstance((Object)new GenericJsonExceptionHandler<NotSupportedException>(Response.Status.BAD_REQUEST){}).addProviderInstance((Object)new GenericJsonExceptionHandler<IOException>(Response.Status.BAD_REQUEST){}).addProviderInstance((Object)new GenericJsonExceptionHandler<ModelValidationException>(Response.Status.BAD_REQUEST){}).addProviderInstance((Object)new GenericJsonExceptionHandler<ConfigException>(Response.Status.BAD_REQUEST){}).addProviderInstance((Object)new GenericJsonExceptionHandler<IllegalArgumentException>(Response.Status.BAD_REQUEST){}).addProviderInstance((Object)new GenericJsonExceptionHandler<ResourceLimitExceededException>(Response.Status.BAD_REQUEST){});
    }

    protected void bindUiApplication() {
        ((GuiceRsModule.ApplicationBindingBuilder)this.bindApplication().matches(new String[]{"/*"})).addResources(new Class[]{UiResource.class});
    }

    protected void enableSwagger(GuiceRsModule.ApplicationBindingBuilder builder) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle("Digdag");
        beanConfig.setDescription("Digdag server API");
        beanConfig.setVersion(DigdagVersion.buildVersion().toString());
        beanConfig.setResourcePackage(VersionResource.class.getPackage().getName());
        beanConfig.setScan();
        builder.addProvider(SwaggerSerializers.class).addProvider(CorsFilter.class).addResources(new Class[]{SwaggerApiListingResource.class});
        logger.info("swagger api enabled on: /api/swagger.{json,yaml}");
    }

    @Path(value="/api/swagger.{type:json|yaml}")
    public static class SwaggerApiListingResource
    extends ApiListingResource {
    }

    @javax.ws.rs.ext.Provider
    @AdminRestricted
    public static class AdminRestrictedFilter
    implements ContainerRequestFilter {
        @Context
        private HttpServletRequest request;

        @Inject
        public AdminRestrictedFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            Object listenAddressName = requestContext.getProperty("io.digdag.guice.rs.server.ListenAddress.name");
            if (listenAddressName == null || !listenAddressName.equals("admin")) {
                throw new NotFoundException();
            }
            AuthenticatedUser user = (AuthenticatedUser)this.request.getAttribute("authenticatedUser");
            if (user == null || !user.isAdmin()) {
                throw new ForbiddenException();
            }
        }
    }

    @javax.ws.rs.ext.Provider
    public static class CustomHeaderFilter
    implements ContainerResponseFilter {
        private final Map<String, String> headers;

        @Inject
        public CustomHeaderFilter(ServerConfig config) {
            this.headers = config.getHeaders();
        }

        public void filter(ContainerRequestContext request, ContainerResponseContext response) {
            this.headers.forEach((arg_0, arg_1) -> ((MultivaluedMap)response.getHeaders()).add(arg_0, arg_1));
        }
    }

    @javax.ws.rs.ext.Provider
    public static class CorsFilter
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext request, ContainerResponseContext response) {
            response.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
            response.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization");
            response.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
            response.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD");
            response.getHeaders().add((Object)"Access-Control-Max-Age", (Object)"1209600");
        }
    }

    public static class JsonProviderProvider
    implements Provider<JacksonJsonProvider> {
        private final ObjectMapper mapper;

        @Inject
        public JsonProviderProvider(ObjectMapper mapper) {
            this.mapper = mapper.copy();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        public JacksonJsonProvider get() {
            return new JacksonJsonProvider(this.mapper);
        }
    }
}

