/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.digdag.server.ImmutableAddress;
import io.digdag.server.ImmutableServerRuntimeInfo;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableServerRuntimeInfo.class)
@JsonDeserialize(as=ImmutableServerRuntimeInfo.class)
@Value.Immutable
public interface ServerRuntimeInfo {
    @JsonProperty(value="local_addresses")
    public List<Address> localAddresses();

    @JsonProperty(value="local_admin_addresses")
    public List<Address> localAdminAddresses();

    public static ImmutableServerRuntimeInfo.Builder builder() {
        return ImmutableServerRuntimeInfo.builder();
    }

    @JsonSerialize(as=ImmutableAddress.class)
    @JsonDeserialize(as=ImmutableAddress.class)
    @Value.Immutable
    public static interface Address {
        public String host();

        public int port();

        public static Address of(String host, int port) {
            return ImmutableAddress.builder().host(host).port(port).build();
        }
    }
}

