/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.digdag.guice.rs.GuiceRsServerControl;
import io.digdag.guice.rs.server.PostStart;
import io.digdag.server.ImmutableServerRuntimeInfo;
import io.digdag.server.ServerConfig;
import io.digdag.server.ServerRuntimeInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRuntimeInfoWriter {
    private static final Logger logger = LoggerFactory.getLogger(ServerRuntimeInfoWriter.class);
    private final Optional<String> serverInfoPath;
    private final GuiceRsServerControl serverControl;

    @Inject
    public ServerRuntimeInfoWriter(ServerConfig serverConfig, GuiceRsServerControl serverControl) {
        this.serverInfoPath = serverConfig.getServerRuntimeInfoPath();
        this.serverControl = serverControl;
    }

    @PostStart
    public void postStart() {
        if (this.serverInfoPath.isPresent()) {
            List apiAddresses = this.serverControl.getRuntimeInfo().getListenAddresses().stream().filter(a -> a.getName().equals("api")).map(a -> a.getSocketAddress()).map(sa -> ServerRuntimeInfo.Address.of(sa.getHostString(), sa.getPort())).collect(Collectors.toList());
            List adminAddresses = this.serverControl.getRuntimeInfo().getListenAddresses().stream().filter(a -> a.getName().equals("admin")).map(a -> a.getSocketAddress()).map(sa -> ServerRuntimeInfo.Address.of(sa.getHostString(), sa.getPort())).collect(Collectors.toList());
            ImmutableServerRuntimeInfo serverRuntimeInfo = ServerRuntimeInfo.builder().localAddresses(apiAddresses).localAdminAddresses(adminAddresses).build();
            ObjectMapper mapper = new ObjectMapper();
            try {
                Files.write(Paths.get((String)this.serverInfoPath.get(), new String[0]), mapper.writeValueAsBytes((Object)serverRuntimeInfo), new OpenOption[0]);
            }
            catch (IOException e) {
                logger.warn("Failed to write server runtime info", (Throwable)e);
            }
        }
    }
}

