/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.auth;

import io.digdag.client.config.ConfigFactory;
import io.digdag.spi.AuthenticatedUser;
import io.digdag.spi.Authenticator;
import io.digdag.spi.ImmutableAuthenticatedUser;
import javax.ws.rs.container.ContainerRequestContext;
import org.jboss.resteasy.util.BasicAuthHelper;

public class BasicAuthenticator
implements Authenticator {
    private final ConfigFactory cf;
    private final String username;
    private final String password;
    private final boolean admin;

    public BasicAuthenticator(ConfigFactory cf, String username, String password, boolean admin) {
        this.cf = cf;
        this.username = username;
        this.password = password;
        this.admin = admin;
    }

    public Authenticator.Result authenticate(ContainerRequestContext requestContext) {
        String authHeader = requestContext.getHeaderString("Authorization");
        if (authHeader == null) {
            return Authenticator.Result.reject((String)"Missing Authorization header");
        }
        String[] parsedHeader = BasicAuthHelper.parseHeader((String)authHeader);
        if (parsedHeader[0].equals(this.username) && parsedHeader[1].equals(this.password)) {
            ImmutableAuthenticatedUser user = AuthenticatedUser.builder().siteId(0).userInfo(this.cf.create()).userContext(this.cf.create()).isAdmin(this.admin).build();
            return Authenticator.Result.accept((AuthenticatedUser)user);
        }
        return Authenticator.Result.reject((String)"unauthorized");
    }
}

