/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.auth;

import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.server.auth.BasicAuthenticator;
import io.digdag.server.auth.NoAuthenticator;
import io.digdag.spi.Authenticator;
import io.digdag.spi.AuthenticatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticatorFactory
implements AuthenticatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthenticatorFactory.class);
    private final Config systemConfig;
    private final ConfigFactory cf;

    @Inject
    public BasicAuthenticatorFactory(Config systemConfig, ConfigFactory cf) {
        this.systemConfig = systemConfig;
        this.cf = cf;
    }

    public String getType() {
        return "basic";
    }

    public Authenticator newAuthenticator() {
        if (this.systemConfig.has("basicauth.username")) {
            logger.warn("Setting basicauth.username or basicauth.password works but is deprecated. It is going to be removed in a near future version. Use server.authenticator.basic.username and server.authenticator.basic.password instead.");
            return new BasicAuthenticator(this.cf, (String)this.systemConfig.get("basicauth.username", String.class), (String)this.systemConfig.get("basicauth.password", String.class), (Boolean)this.systemConfig.get("basicauth.admin", Boolean.TYPE, (Object)false));
        }
        if (this.systemConfig.has("server.authenticator.basic.username")) {
            return new BasicAuthenticator(this.cf, (String)this.systemConfig.get("server.authenticator.basic.username", String.class), (String)this.systemConfig.get("server.authenticator.basic.password", String.class), (Boolean)this.systemConfig.get("server.authenticator.basic.admin", Boolean.TYPE, (Object)false));
        }
        return new NoAuthenticator(this.cf);
    }
}

