/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import io.digdag.client.config.ConfigException;
import io.digdag.metrics.DigdagTimed;
import io.digdag.metrics.StdDigdagMetrics;
import io.digdag.server.metrics.DigdagMetricsConfig;
import io.digdag.server.metrics.DigdagTimedMethodInterceptor;
import io.digdag.server.metrics.fluency.FluencyMonitorSystemConfig;
import io.digdag.spi.metrics.DigdagMetrics;
import io.github.yoyama.micrometer.FluencyMeterRegistry;
import io.github.yoyama.micrometer.FluencyRegistryConfig;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.komamitsu.fluency.Fluency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigdagMetricsModule
extends AbstractModule {
    protected final DigdagMetricsConfig metricsConfig;
    private static final Logger logger = LoggerFactory.getLogger(DigdagMetricsModule.class);
    private final Map<DigdagMetrics.Category, String> categoryToJMXdomain = ImmutableMap.of((Object)DigdagMetrics.Category.DEFAULT, (Object)"io.digdag", (Object)DigdagMetrics.Category.AGENT, (Object)"io.digdag.agent", (Object)DigdagMetrics.Category.API, (Object)"io.digdag.api", (Object)DigdagMetrics.Category.DB, (Object)"io.digdag.db", (Object)DigdagMetrics.Category.EXECUTOR, (Object)"io.digdag.executor");

    public DigdagMetricsModule(DigdagMetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    public void configure() {
        this.configureMeterRegistry();
        this.binder().bind(DigdagMetrics.class).to(StdDigdagMetrics.class);
        this.configureInterceptor();
    }

    public void configureMeterRegistry() {
        this.bindMeterRegistry(DigdagMetrics.Category.DEFAULT);
        this.bindMeterRegistry(DigdagMetrics.Category.AGENT);
        this.bindMeterRegistry(DigdagMetrics.Category.API);
        this.bindMeterRegistry(DigdagMetrics.Category.DB);
        this.bindMeterRegistry(DigdagMetrics.Category.EXECUTOR);
    }

    protected void bindMeterRegistry(DigdagMetrics.Category category) {
        this.binder().bind(MeterRegistry.class).annotatedWith((Annotation)Names.named((String)category.getString())).toInstance((Object)this.createCompositeMeterRegistry(category));
    }

    protected CompositeMeterRegistry createCompositeMeterRegistry(DigdagMetrics.Category category) {
        CompositeMeterRegistry registry = new CompositeMeterRegistry();
        if (this.isEnableCategory("jmx", category)) {
            registry.add((MeterRegistry)this.createJmxMeterRegistry(category));
        }
        if (this.isEnableCategory("fluency", category)) {
            registry.add((MeterRegistry)this.createFluencyMeterRegistry(category));
        }
        return registry;
    }

    protected boolean isEnableCategory(String key, DigdagMetrics.Category category) {
        return (Boolean)this.metricsConfig.getMonitorSystemConfig(key).transform(p -> p.getCategoryEnable(category)).or((Object)false);
    }

    protected JmxMeterRegistry createJmxMeterRegistry(DigdagMetrics.Category category) {
        return new JmxMeterRegistry(this.createJmxConfig(this.categoryToJMXdomain.get(category)), Clock.SYSTEM);
    }

    private JmxConfig createJmxConfig(final String domain) {
        return new JmxConfig(){

            public String get(String key) {
                return null;
            }

            public String domain() {
                return domain;
            }
        };
    }

    @VisibleForTesting
    public FluencyMeterRegistry createFluencyMeterRegistry(DigdagMetrics.Category category) {
        FluencyMonitorSystemConfig fconfig = (FluencyMonitorSystemConfig)this.metricsConfig.getMonitorSystemConfig("fluency").or(() -> {
            throw new ConfigException("fluency is disabled");
        });
        Fluency fluency = FluencyMonitorSystemConfig.createFluency(fconfig);
        FluencyRegistryConfig regConfig = FluencyRegistryConfig.apply((String)fconfig.getTag(), (String)"digdag", (Duration)Duration.ofSeconds(fconfig.getStep()), (boolean)false);
        return FluencyMeterRegistry.apply((FluencyRegistryConfig)regConfig, (HierarchicalNameMapper)HierarchicalNameMapper.DEFAULT, (Clock)Clock.SYSTEM, (Fluency)fluency);
    }

    public void configureInterceptor() {
        DigdagTimedMethodInterceptor interceptor = new DigdagTimedMethodInterceptor();
        this.requestInjection(interceptor);
        this.binder().bindInterceptor(Matchers.any(), Matchers.annotatedWith(DigdagTimed.class), new MethodInterceptor[]{interceptor});
    }
}

