/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.server.metrics;

import com.google.inject.Inject;
import io.digdag.metrics.DigdagTimed;
import io.digdag.spi.TaskRequest;
import io.digdag.spi.metrics.DigdagMetrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigdagTimedMethodInterceptor
implements MethodInterceptor {
    private static Logger logger = LoggerFactory.getLogger(DigdagTimedMethodInterceptor.class);
    @Inject
    DigdagMetrics metrics;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.invokeMain(invocation);
        }
        catch (Exception e) {
            logger.debug("invocationMain Failed. {}", (Object)e.toString());
            throw e;
        }
    }

    public Object invokeMain(MethodInvocation invocation) throws Throwable {
        DigdagTimed timed = invocation.getMethod().getAnnotation(DigdagTimed.class);
        DigdagMetrics.Category category = DigdagMetrics.Category.fromString((String)timed.category());
        String value = this.mkValue(timed, invocation);
        String metricsName = this.metrics.mkMetricsName(category, value);
        Tags taskTags = Tags.empty();
        try {
            taskTags = timed.taskRequest() ? this.getTaskRequest(invocation) : Tags.empty();
        }
        catch (Exception e) {
            logger.debug(e.toString());
        }
        Timer.Sample sample = this.metrics.timerStart(category);
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            try {
                this.metrics.timerStop(category, metricsName, taskTags.and(timed.extraTags()), sample);
            }
            catch (Exception e) {
                logger.warn(e.toString());
            }
        }
    }

    protected String mkValue(DigdagTimed timed, MethodInvocation invocation) {
        String value = timed.value() != null ? timed.value() : "";
        String methodName = invocation.getMethod().getName();
        if (timed.appendMethodName() && methodName != null) {
            value = value + methodName;
        }
        if (value.compareTo("") == 0) {
            value = "unknown";
        }
        return value;
    }

    protected Tags getTaskRequest(MethodInvocation invocation) {
        for (Object arg : invocation.getArguments()) {
            if (!(arg instanceof TaskRequest)) continue;
            TaskRequest request = (TaskRequest)arg;
            return Tags.of((String[])new String[]{"site_id", Integer.toString(request.getSiteId()), "project_id", Integer.toString(request.getProjectId()), "project_name", (String)request.getProjectName().or((Object)"unknown"), "workflow_name", request.getWorkflowName()});
        }
        return Tags.empty();
    }
}

